/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.brazier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.block.curiosities.soul_brazier.SoulBrazierBlockEntity;
import com.sammy.malum.visual_effects.SoulBindingBrazierParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;

public class SoulBrazierAcceptSacrificeParticleEffect
extends MalumNetworkedParticleEffectType<SoulBrazierEntityEffectData> {
    public SoulBrazierAcceptSacrificeParticleEffect(String id) {
        super(id);
    }

    public Optional<StreamCodec<ByteBuf, ? extends NetworkedParticleEffectExtraData>> getExtraCodec() {
        return Optional.of(SoulBrazierEntityEffectData.STREAM_CODEC);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, SoulBrazierEntityEffectData extraData) {
        BlockEntity blockEntity = level.getBlockEntity(positionData.getAsBlockPos());
        if (!(blockEntity instanceof SoulBrazierBlockEntity)) {
            return;
        }
        SoulBrazierBlockEntity brazier = (SoulBrazierBlockEntity)blockEntity;
        Entity entity = level.getEntity(extraData.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            SoulBindingBrazierParticleEffects.acceptSacrificeParticles(brazier, entity2, colorData);
        }
    }

    public record SoulBrazierEntityEffectData(int entityId) implements NetworkedParticleEffectExtraData
    {
        public static final Codec<SoulBrazierEntityEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("entityId").forGetter(SoulBrazierEntityEffectData::entityId)).apply((Applicative)instance, SoulBrazierEntityEffectData::new));
        public static final StreamCodec<ByteBuf, SoulBrazierEntityEffectData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

