/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.sts15.fargos.config.PlayerDataHandler;
import com.sts15.fargos.network.NetworkHandler;
import com.sts15.fargos.network.TalismanType;
import com.sts15.fargos.network.TrinketType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TalismanCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TALISMAN = (context, builder) -> {
        for (TalismanType talisman : TalismanType.values()) {
            builder.suggest(talisman.name().toLowerCase());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TRINKET = (context, builder) -> {
        for (TrinketType trinket : TrinketType.values()) {
            builder.suggest(trinket.name().toLowerCase());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fargostalismans").requires(source -> source.hasPermission(0))).then(Commands.literal((String)"talisman").then(Commands.literal((String)"toggle").then(Commands.argument((String)"talisman", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_TALISMAN).executes(TalismanCommand::executeToggle))))).then(Commands.literal((String)"trinket").then(Commands.literal((String)"toggle").then(Commands.argument((String)"trinket", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_TRINKET).executes(TalismanCommand::executeTrinketToggle))));
        dispatcher.register(command);
    }

    public static int executeToggle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        TalismanType talismanType;
        String talismanName = StringArgumentType.getString(context, (String)"talisman").toUpperCase();
        try {
            talismanType = TalismanType.valueOf(talismanName);
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid talisman name: " + talismanName)));
            return 0;
        }
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            boolean isEnabled = !PlayerDataHandler.getTalismanState(player, talismanType.name());
            PlayerDataHandler.setTalismanState(player, talismanType.name(), isEnabled);
            player.displayClientMessage((Component)Component.literal((String)("Toggled talisman: " + talismanName + " to " + (isEnabled ? "enabled" : "disabled"))), true);
        } else {
            int talismanIndex = talismanType.getIndex();
            boolean isEnabled = !PlayerDataHandler.getTalismanState(((CommandSourceStack)context.getSource()).getPlayerOrException(), talismanType.name());
            NetworkHandler.sendToggleTalismanStateToServer(talismanIndex, isEnabled);
        }
        return 1;
    }

    public static int executeTrinketToggle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        TalismanType talismanType;
        String talismanName = StringArgumentType.getString(context, (String)"trinket").toUpperCase();
        try {
            talismanType = TalismanType.valueOf(talismanName);
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid trinket name: " + talismanName)));
            return 0;
        }
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            boolean isEnabled = !PlayerDataHandler.getTalismanState(player, talismanType.name());
            PlayerDataHandler.setTalismanState(player, talismanType.name(), isEnabled);
            player.displayClientMessage((Component)Component.literal((String)("Toggled trinket: " + talismanName + " to " + (isEnabled ? "enabled" : "disabled"))), true);
        } else {
            int talismanIndex = talismanType.getIndex();
            boolean isEnabled = !PlayerDataHandler.getTalismanState(((CommandSourceStack)context.getSource()).getPlayerOrException(), talismanType.name());
            NetworkHandler.sendToggleTalismanStateToServer(talismanIndex, isEnabled);
        }
        return 1;
    }
}

