/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.souls;

import com.illusivesoulworks.caelus.api.CaelusApi;
import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.init.SoundRegistry;
import com.sts15.fargos.items.crafted.BasicElytraItem;
import com.sts15.fargos.items.providers.Soul_of_Flight_Mastery_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Soul_of_Flight_Mastery
extends BasicElytraItem
implements Soul_of_Flight_Mastery_Provider {
    public static final String talismanName = "soul_of_flight_mastery";
    private static final ResourceLocation FLIGHT_ENABLE_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"soul_of_flight_mastery_enabled");
    private static final ResourceLocation ELYTRA_FLIGHT_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"soul_of_flight_mastery_elytra");

    public Soul_of_Flight_Mastery() {
        super(new Item.Properties().rarity(Rarity.EPIC), ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"textures/entity/elytra/soul_of_flight_mastery.png"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.soul_of_flight_mastery").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Soul_of_Flight_Mastery.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    public static void enableFlight(Player player) {
        AttributeInstance elytraAttr;
        AttributeInstance creativeFlight = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (creativeFlight != null && creativeFlight.getBaseValue() == 0.0 && !player.isCreative() && !player.isSpectator()) {
            creativeFlight.setBaseValue(1.0);
            player.getPersistentData().putBoolean(FLIGHT_ENABLE_ID.toString(), true);
        }
        if ((elytraAttr = player.getAttribute(CaelusApi.getInstance().getFallFlyingAttribute())) != null && elytraAttr.getModifier(ELYTRA_FLIGHT_ID) == null) {
            elytraAttr.addTransientModifier(new AttributeModifier(ELYTRA_FLIGHT_ID, 1.0, AttributeModifier.Operation.ADD_VALUE));
        }
        player.onUpdateAbilities();
    }

    public static void disableFlight(Player player) {
        AttributeInstance elytraAttr;
        AttributeInstance creativeFlight = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (creativeFlight != null && creativeFlight.getBaseValue() == 1.0 && !player.isCreative() && !player.isSpectator()) {
            creativeFlight.setBaseValue(0.0);
            player.getAbilities().flying = false;
            player.getAbilities().mayfly = false;
        }
        if ((elytraAttr = player.getAttribute(CaelusApi.getInstance().getFallFlyingAttribute())) != null && elytraAttr.getModifier(ELYTRA_FLIGHT_ID) != null) {
            elytraAttr.removeModifier(ELYTRA_FLIGHT_ID);
        }
        player.onUpdateAbilities();
        player.getPersistentData().remove(FLIGHT_ENABLE_ID.toString());
    }

    private static boolean isFlightEnabledByMod(Player player) {
        return player.getPersistentData().getBoolean(FLIGHT_ENABLE_ID.toString());
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    protected String getFirstTimeMessageKey() {
        return null;
    }

    protected Component getFirstTimeMessageComponent() {
        return null;
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Level level = slotContext.entity().level();
        if (!level.isClientSide) {
            Player player = (Player)slotContext.entity();
            level.playSound(null, player.blockPosition(), SoundRegistry.EQUIP_TALISMAN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            String key = this.getFirstTimeMessageKey();
            if (key != null && !player.getPersistentData().getBoolean(key)) {
                Component msg = this.getFirstTimeMessageComponent();
                if (msg != null) {
                    player.sendSystemMessage(msg);
                }
                player.getPersistentData().putBoolean(key, true);
            }
        }
        if (TalismanUtil.isTalismanEnabled((Player)slotContext.entity(), talismanName)) {
            Soul_of_Flight_Mastery.enableFlight((Player)slotContext.entity());
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Level level = slotContext.entity().level();
        if (!level.isClientSide) {
            Player player = (Player)slotContext.entity();
            level.playSound(null, player.blockPosition(), SoundRegistry.UNEQUIP_TALISMAN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        Soul_of_Flight_Mastery.disableFlight((Player)slotContext.entity());
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            boolean shouldFly;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (++tickCounter < 10) {
                return;
            }
            tickCounter = 0;
            boolean configOn = TalismanUtil.isTalismanEnabled(player2, Soul_of_Flight_Mastery.talismanName);
            boolean hasSoul = player2.hasEffect(EffectsInit.SOUL_OF_FLIGHT_MASTERY_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Soul_of_Flight_Mastery_Provider, (LivingEntity)player2).isPresent();
            boolean flightOn = Soul_of_Flight_Mastery.isFlightEnabledByMod((Player)player2);
            boolean bl = shouldFly = configOn && hasSoul;
            if (shouldFly && !flightOn) {
                Soul_of_Flight_Mastery.enableFlight((Player)player2);
            } else if (!shouldFly && flightOn) {
                Soul_of_Flight_Mastery.disableFlight((Player)player2);
            }
        }
    }
}

