/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Gold_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={PiglinAi.class})
public class PiglinAiMixin {
    @Inject(method={"findNearestValidAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onFindNearestValidAttackTarget(Piglin piglin, CallbackInfoReturnable<Optional<? extends LivingEntity>> cir) {
        Player player;
        Brain brain = piglin.getBrain();
        Optional optionalPlayer = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (optionalPlayer.isPresent() && PiglinAiMixin.hasGoldEnchantment(player = (Player)optionalPlayer.get())) {
            cir.setReturnValue(Optional.empty());
        }
    }

    private static boolean hasGoldEnchantment(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TalismanUtil.isTalismanEnabled(serverPlayer, "gold_talisman")) {
                return false;
            }
            return player.hasEffect(EffectsInit.GOLD_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Gold_Talisman_Provider, (LivingEntity)serverPlayer).isPresent();
        }
        return false;
    }
}

