/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.enums;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ComponentFactory;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum ConnectorMode implements ITranslatableEnum<ConnectorMode>,
StringRepresentable
{
    INS("xnetgases.enum.connector_mode.ins"),
    EXT("xnetgases.enum.connector_mode.ext");

    public static final Codec<ConnectorMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, ConnectorMode> STREAM_CODEC;
    private static final Map<String, ConnectorMode> NAME_MAP;
    private final String i18n;

    private ConnectorMode(String i18n) {
        this.i18n = i18n;
    }

    public static ConnectorMode byName(String name) {
        return NAME_MAP.get(name);
    }

    public String getI18n() {
        return ComponentFactory.translatable((String)this.i18n).getString();
    }

    public String[] getI18nSplitedTooltip() {
        return I18nUtils.getSplitedEnumTooltip((String)this.i18n);
    }

    @Nonnull
    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ConnectorMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(ConnectorMode.class);
        NAME_MAP = Arrays.stream(ConnectorMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

