/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.logic.RSOutput;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.ChemicalMatcher;
import terrails.xnetgases.module.logic.ChemicalLogicChannelType;
import terrails.xnetgases.module.logic.ChemicalSensor;
import terrails.xnetgases.module.logic.enums.SensorMode;
import terrails.xnetgases.module.logic.enums.SensorOperator;

public class ChemicalLogicConnectorSettings
extends AbstractConnectorSettings {
    public static final MapCodec<ChemicalLogicConnectorSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractConnectorSettings.BaseSettings.CODEC.fieldOf("base").forGetter(s -> s.settings), (App)Direction.CODEC.fieldOf("side").forGetter(AbstractConnectorSettings::getSide), (App)LogicMode.CODEC.fieldOf("mode").forGetter(ChemicalLogicConnectorSettings::getConnectorMode), (App)RSOutput.CODEC.fieldOf("output").forGetter(ChemicalLogicConnectorSettings::getOutput), (App)Codec.list(ChemicalSensor.CODEC).fieldOf("sensors").forGetter(ChemicalLogicConnectorSettings::getSensors)).apply((Applicative)instance, ChemicalLogicConnectorSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalLogicConnectorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)AbstractConnectorSettings.BaseSettings.STREAM_CODEC, s -> s.settings, (StreamCodec)Direction.STREAM_CODEC, AbstractConnectorSettings::getSide, (StreamCodec)LogicMode.STREAM_CODEC, ChemicalLogicConnectorSettings::getConnectorMode, (StreamCodec)RSOutput.STREAM_CODEC, ChemicalLogicConnectorSettings::getOutput, (StreamCodec)ChemicalSensor.STREAM_CODEC.apply(ByteBufCodecs.list()), ChemicalLogicConnectorSettings::getSensors, ChemicalLogicConnectorSettings::new);
    private static final int MAX_SENSORS = 4;
    private final List<ChemicalSensor> sensors;
    private LogicMode connectorMode = LogicMode.SENSOR;
    private RSOutput output;
    private int colorMask;

    public ChemicalLogicConnectorSettings(@Nonnull AbstractConnectorSettings.BaseSettings base, @Nonnull Direction direction, LogicMode connectorMode, RSOutput output, List<ChemicalSensor> sensors) {
        super(base, direction);
        this.connectorMode = connectorMode;
        this.output = output;
        this.sensors = sensors;
    }

    public ChemicalLogicConnectorSettings(@Nonnull Direction direction) {
        super(DEFAULT_SETTINGS, direction);
        this.sensors = IntStream.range(0, 4).mapToObj(ChemicalSensor::new).collect(Collectors.toCollection(ArrayList::new));
        this.output = new RSOutput(this.advanced);
    }

    public IChannelType getType() {
        return ChemicalLogicChannelType.TYPE;
    }

    public List<ChemicalSensor> getSensors() {
        return this.sensors;
    }

    public LogicMode getConnectorMode() {
        return this.connectorMode;
    }

    public RSOutput getOutput() {
        return this.output;
    }

    public int getColorMask() {
        return this.colorMask;
    }

    public void setColorMask(int colors) {
        this.colorMask = colors;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().translatableChoices("logicMode", (ITranslatableEnum)this.connectorMode, (ITranslatableEnum[])LogicMode.values()).nl();
        if (this.getConnectorMode() == LogicMode.SENSOR) {
            this.sensors.forEach(s -> s.createGui(gui));
        } else {
            this.output.createGui(gui);
        }
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.getConnectorMode() != LogicMode.OUTPUT;
        }
        for (ChemicalSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        if (this.output.isEnabled(tag)) {
            return true;
        }
        return Constants.CHEMICAL_LOGIC_FEATURES.contains(tag);
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.connectorMode = Optional.ofNullable(data.get("logicMode")).map(o -> LogicMode.values()[(Integer)o]).orElse(LogicMode.SENSOR);
        if (this.connectorMode == LogicMode.SENSOR) {
            this.sensors.forEach(sensors -> sensors.update(data));
        } else {
            this.output.update(data);
        }
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.connectorMode) {
            default -> throw new MatchException(null, null);
            case LogicMode.SENSOR -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 26, 70, 13, 10);
            case LogicMode.OUTPUT -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 39, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.output.writeToNBT(tag);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.output.readFromNBT(tag);
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)object, (String)"logicMode", (Enum)this.connectorMode);
        JsonArray sensorArray = new JsonArray();
        for (ChemicalSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"sensorMode", (Enum)sensor.getSensorMode());
            ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"outputcolor", (Enum)sensor.getOutputColor());
            ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"operator", (Enum)sensor.getOperator());
            ChemicalLogicConnectorSettings.setIntegerSafe((JsonObject)o, (String)"amount", (Integer)sensor.getAmount());
            if (!sensor.getMatcher().isEmpty()) {
                o.add("filter", JSonTools.itemStackToJson((ItemStack)sensor.getMatcher().getStack()));
            }
            sensorArray.add((JsonElement)o);
        }
        object.add("sensors", (JsonElement)sensorArray);
        if (!this.output.getLogicFilter().equals((Object)LogicFilter.DIRECT)) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        JsonObject outputJSON = new JsonObject();
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSFilter", (Enum)this.output.getLogicFilter());
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSChannel1", (Enum)this.output.getInputChannel1());
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSChannel2", (Enum)this.output.getInputChannel2());
        outputJSON.addProperty("RSCountingHolder", (Number)this.output.getCountingHolder());
        outputJSON.addProperty("RSTicksHolder", (Number)this.output.getTicksHolder());
        outputJSON.addProperty("rsout", (Number)this.output.getRedstoneOut());
        object.add("output", (JsonElement)outputJSON);
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.connectorMode = (LogicMode)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)object, (String)"logicMode", EnumStringTranslators::getLogicMode);
        JsonArray sensorArray = object.get("sensors").getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            ChemicalSensor sensor = new ChemicalSensor(this.sensors.size());
            sensor.setSensorMode((SensorMode)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"sensorMode", SensorMode::byName));
            sensor.setOutputColor((Color)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"outputcolor", BaseStringTranslators::getColor));
            sensor.setOperator((SensorOperator)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"operator", SensorOperator::byName));
            sensor.setAmount(ChemicalLogicConnectorSettings.getIntegerNotNull((JsonObject)o, (String)"amount"));
            if (o.has("filter")) {
                sensor.setMatcher(ChemicalMatcher.from(JSonTools.jsonToItemStack((JsonObject)o.get("filter").getAsJsonObject())));
            } else {
                sensor.setMatcher(ChemicalMatcher.EMPTY);
            }
            this.sensors.add(sensor);
        }
        JsonObject outputJSON = object.getAsJsonObject("output");
        this.output = new RSOutput(this.advanced);
        this.output.setLogicFilter((LogicFilter)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSFilter", EnumStringTranslators::getLogicFilter));
        this.output.setInputChannel1((Color)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSChannel1", BaseStringTranslators::getColor));
        this.output.setInputChannel2((Color)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSChannel2", BaseStringTranslators::getColor));
        this.output.setCountingHolder(ChemicalLogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"RSCountingHolder"));
        this.output.setTicksHolder(ChemicalLogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"RSTicksHolder"));
        this.output.setRedstoneOut(ChemicalLogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"rsout"));
    }
}

