/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.api.inventory;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CAStacksBase
extends ItemStackHandler {
    protected final Map<String, Set<String>> hidden = new HashMap<String, Set<String>>();
    protected boolean[] isSkinArmor = new boolean[this.stacks.size()];

    public CAStacksBase() {
        this(4);
    }

    public CAStacksBase(int size) {
        super(size);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stacks.size());
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.contains("id")) {
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTags).ifPresent(stack -> this.stacks.set(slot, stack));
            }
            if (!itemTags.contains("isSkinArmor")) continue;
            this.isSkinArmor[slot] = itemTags.getBoolean("isSkinArmor");
        }
        this.hidden.clear();
        Arrays.stream(nbt.getString("Hidden").split("\u0000")).forEach(str -> {
            int i = str.indexOf(":");
            if (i != -1) {
                this.hidden.computeIfAbsent(str.substring(0, i), key -> new HashSet()).add(str.substring(i + 1));
            }
        });
        this.onLoad();
    }

    public void forEachHidden(BiConsumer<String, String> consumer) {
        for (String modid : this.hidden.keySet()) {
            for (String identifier : this.hidden.get(modid)) {
                consumer.accept(modid, identifier);
            }
        }
    }

    public boolean isHidden(String modid, String identifier) {
        return this.hidden.getOrDefault(modid, Collections.emptySet()).contains(identifier);
    }

    public boolean isSkinArmor(int slot) {
        this.validateSlotIndex(slot);
        return this.isSkinArmor[slot];
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty() && !this.isSkinArmor[i]) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            if (!((ItemStack)this.stacks.get(i)).isEmpty()) {
                itemTag = (CompoundTag)((ItemStack)this.stacks.get(i)).save(provider, (Tag)itemTag);
            }
            if (this.isSkinArmor[i]) {
                itemTag.putBoolean("isSkinArmor", true);
            }
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.stacks.size());
        nbt.putString("Hidden", this.hidden.entrySet().stream().map(entry -> ((Set)entry.getValue()).stream().map(value -> (String)entry.getKey() + ":" + value).collect(Collectors.joining("\u0000"))).collect(Collectors.joining("\u0000")));
        return nbt;
    }

    public boolean setHidden(String modid, String identifier, boolean set) {
        if (set) {
            return this.hidden.computeIfAbsent(modid, key -> new HashSet()).add(identifier);
        }
        return this.hidden.getOrDefault(modid, Collections.emptySet()).remove(identifier);
    }

    public void setSize(int size) {
        super.setSize(size);
        this.isSkinArmor = new boolean[this.stacks.size()];
    }

    public void setSkinArmor(int slot, boolean enabled) {
        this.validateSlotIndex(slot);
        if (this.isSkinArmor[slot] == enabled) {
            return;
        }
        this.isSkinArmor[slot] = enabled;
        this.onContentsChanged(slot);
    }
}

