/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission.provider;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class ClaimPermissionProvider
implements DataProvider {
    private final Map<ResourceLocation, ClaimPermission.Builder> data = new LinkedHashMap<ResourceLocation, ClaimPermission.Builder>();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public ClaimPermissionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        this.output = output;
        this.lookup = lookup;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.lookup.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> CompletableFuture.allOf((CompletableFuture[])this.data.entrySet().stream().map(entry -> {
            ResourceLocation res = (ResourceLocation)entry.getKey();
            Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + PermissionManager.DIRECTORY + "/" + res.getPath() + ".json");
            JsonElement obj = (JsonElement)ClaimPermission.Builder.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)((ClaimPermission.Builder)entry.getValue())).getOrThrow();
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path);
        }).toArray(CompletableFuture[]::new)));
    }

    public String getName() {
        return "Permissions";
    }

    public void addPermission(ResourceLocation res, ClaimPermission.Builder permission) {
        if (this.data.put(res, permission) != null) {
            throw new IllegalStateException("Permission already registered for " + String.valueOf(res));
        }
    }

    public Map<ResourceLocation, ClaimPermission.Builder> getData() {
        return ImmutableMap.copyOf(this.data);
    }
}

