/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.server.level.ServerPlayer;

public class ClaimBlocksCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"giveClaimBlocks").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.give", true))).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ClaimBlocksCommand::giveClaimBlocks))).then(Commands.literal((String)"base").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ClaimBlocksCommand.giveClaimBlocks((CommandContext<CommandSourceStack>)ctx, true))))));
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimBlocksCommand.giveClaimBlocks(context, false);
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context, boolean base) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ArrayList<String> players = new ArrayList<String>();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (GameProfile prof : GameProfileArgument.getGameProfiles(context, (String)"players")) {
            ServerPlayer player = src.getServer().getPlayerList().getPlayer(prof.getId());
            if (player != null) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (base) {
                    data.addClaimBlocksDirect(amount);
                } else {
                    data.setAdditionalClaims(data.getAdditionalClaims() + amount);
                }
            } else {
                PlayerClaimData.editForOfflinePlayer(src.getServer(), prof.getId(), amount, base);
            }
            players.add(prof.getName());
        }
        src.sendSuccess(() -> ClaimUtils.translatedText(base ? "flan.giveClaimBlocks" : "flan.giveClaimBlocksBonus", players, amount, ChatFormatting.GOLD), true);
        return players.size();
    }
}

