/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class FakePlayerCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakePlayer").executes(FakePlayerCommand::toggleFakePlayer)).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).executes(FakePlayerCommand::addFakePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).suggests((context, build) -> {
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.getLevel());
            Claim claim = storage.getClaimAt(src.getPlayerOrException().blockPosition());
            if (claim != null && claim.canInteract(src.getPlayerOrException(), BuiltinPermission.EDITPERMS, src.getPlayerOrException().blockPosition())) {
                list = claim.getAllowedFakePlayerUUID();
            }
            return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
        }).executes(FakePlayerCommand::removeFakePlayer))));
    }

    private static int toggleFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        data.setFakePlayerNotif(!(data = PlayerClaimData.get(player)).hasFakePlayerNotificationOn());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.fakePlayerNotification", data.hasFakePlayerNotificationOn(), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int addFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return FakePlayerCommand.modifyFakePlayer(context, false);
    }

    private static int removeFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return FakePlayerCommand.modifyFakePlayer(context, true);
    }

    private static int modifyFakePlayer(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITPERMS);
        if (claim == null) {
            return 0;
        }
        UUID uuid = UuidArgument.getUuid(context, (String)"uuid");
        if (claim.modifyFakePlayerUUID(uuid, remove)) {
            if (!remove) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.uuidFakeAdd", uuid, ChatFormatting.GOLD), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.uuidFakeRemove", uuid, ChatFormatting.GOLD), false);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.uuidFakeModifyNo", ChatFormatting.RED));
        return 0;
    }
}

