/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;

public class TeleportCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.teleport"))).then(Commands.literal((String)"self").then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID())).executes(TeleportCommand::teleport)))).then(Commands.literal((String)"global").then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, null)).executes(TeleportCommand::teleportAdminClaims)))).then(Commands.literal((String)"other").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)ctx, "player").getId())).executes(src -> TeleportCommand.teleport((CommandContext<CommandSourceStack>)src, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)src, "player").getId()))))));
    }

    private static int teleport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeleportCommand.teleport(context, ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID());
    }

    private static int teleportAdminClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeleportCommand.teleport(context, null);
    }

    private static int teleport(CommandContext<CommandSourceStack> context, UUID owner) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String name = StringArgumentType.getString(context, (String)"claim");
        Optional<Claim> claims = ClaimStorage.get(((CommandSourceStack)context.getSource()).getLevel()).allClaimsFromPlayer(owner).stream().filter(claim -> {
            if (claim.getClaimName().isEmpty()) {
                return claim.getClaimID().toString().equals(name);
            }
            return claim.getClaimName().equals(name);
        }).findFirst();
        if (claims.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportNoClaim", ChatFormatting.RED), false);
            return 0;
        }
        return claims.map(claim -> {
            BlockPos pos = claim.getHomePos();
            if (claim.canInteract(player, BuiltinPermission.TELEPORT, pos, false)) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (data.setTeleportTo(pos)) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportHome", ChatFormatting.GOLD), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportHomeFail", ChatFormatting.RED), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), false);
            }
            return 0;
        }).orElse(0);
    }
}

