/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ConfigUpdater {
    private static final Map<Integer, Updater> UPDATER = Config.createHashMap(map -> {
        map.put(7, new Updater(){

            @Override
            public JsonObject configUpdater(JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(Config config) {
                config.defaultGroups.computeIfPresent("Co-Owner", (k, v) -> {
                    if (v.isEmpty()) {
                        PermissionManager.getInstance().getAll().forEach(p -> v.put(p.getId(), true));
                    }
                    return v;
                });
                config.defaultGroups.computeIfPresent("Visitor", (k, v) -> {
                    if (v.isEmpty()) {
                        v.put(BuiltinPermission.BED, true);
                        v.put(BuiltinPermission.DOOR, true);
                        v.put(BuiltinPermission.FENCEGATE, true);
                        v.put(BuiltinPermission.TRAPDOOR, true);
                        v.put(BuiltinPermission.BUTTONLEVER, true);
                        v.put(BuiltinPermission.PRESSUREPLATE, true);
                        v.put(BuiltinPermission.ENDERCHEST, true);
                        v.put(BuiltinPermission.ENCHANTMENTTABLE, true);
                        v.put(BuiltinPermission.ITEMFRAMEROTATE, true);
                        v.put(BuiltinPermission.PORTAL, true);
                        v.put(BuiltinPermission.TRADING, true);
                    }
                    return v;
                });
            }
        });
        map.put(6, new Updater(){

            @Override
            public JsonObject configUpdater(JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(Config config) {
                config.globalDefaultPerms.computeIfPresent("*", (k, v) -> {
                    v.put(BuiltinPermission.ALLOW_FLIGHT, Config.GlobalType.ALLTRUE);
                    v.put(BuiltinPermission.MAY_FLIGHT, Config.GlobalType.ALLFALSE);
                    return v;
                });
            }
        });
        map.put(5, config -> {
            Flan.debug("Updating config to version 5", new Object[0]);
            JsonObject buySellHandler = ConfigHandler.fromJson(config, "buySellHandler");
            JsonArray buyItems = ConfigHandler.arrayFromJson(buySellHandler, "buyIngredients");
            ArrayList toRemove = new ArrayList();
            buyItems.forEach(k -> {
                JsonObject o = k.getAsJsonObject();
                if (o.has("ingredient")) {
                    try {
                        Ingredient ingredient = (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)buySellHandler.get("ingredient")).getOrThrow();
                        ItemPredicate pred = ItemPredicate.Builder.item().of((ItemLike[])Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).toArray(ItemLike[]::new)).build();
                        o.add("predicate", (JsonElement)ItemPredicate.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pred).getOrThrow());
                        o.remove("ingredient");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!o.has("predicate") || !o.has("amount")) {
                    Flan.error("Unable to update buy handler ", o);
                    toRemove.add(k);
                }
            });
            toRemove.forEach(arg_0 -> ((JsonArray)buyItems).remove(arg_0));
            buySellHandler.add("buyItems", (JsonElement)buyItems);
            if (buySellHandler.has("ingredient") || buySellHandler.has("sellIngredient")) {
                Ingredient legacy = buySellHandler.has("ingredient") ? (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)buySellHandler.get("ingredient")).getOrThrow() : Ingredient.EMPTY;
                Ingredient ingredient = legacy = buySellHandler.has("sellIngredient") ? (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)buySellHandler.get("sellIngredient")).getOrThrow() : legacy;
                if (!legacy.isEmpty() && !legacy.getItems()[0].isEmpty()) {
                    buySellHandler.add("sellItems", (JsonElement)BuySellHandler.ITEM_STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)legacy.getItems()[0]).result().map(e -> {
                        JsonArray arr = new JsonArray();
                        JsonObject val = new JsonObject();
                        val.add("amount", buySellHandler.get("sellValue"));
                        val.add("item", e);
                        arr.add((JsonElement)val);
                        return arr;
                    }).orElse(new JsonArray()));
                } else {
                    buySellHandler.add("sellItems", (JsonElement)new JsonArray());
                }
            }
            return config;
        });
    });

    public static JsonObject updateConfig(int preVersion, JsonObject config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            config = updater.getValue().configUpdater(config);
        }
        return config;
    }

    public static void postUpdateConfig(int preVersion, Config config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            updater.getValue().postUpdater(config);
        }
    }

    static interface Updater {
        public JsonObject configUpdater(JsonObject var1);

        default public void postUpdater(Config config) {
        }
    }
}

