/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClaimAllowListEntryScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private static final Map<Integer, ClaimAllowListKey<?>> UI_VALUES = ClaimAllowListEntryScreenHandler.withEntries();

    private ClaimAllowListEntryScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 1 + UI_VALUES.size() / 5, claim);
    }

    private static Map<Integer, ClaimAllowListKey<?>> withEntries() {
        HashMap values = new HashMap();
        int idx = 2;
        for (ClaimAllowListKey<?> val : ClaimAllowListKey.keys().values()) {
            values.put(idx, val);
            if (++idx % 9 <= 6) continue;
            idx += 4;
        }
        return values;
    }

    public static void openScreen(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ClaimAllowListEntryScreenHandler(syncId, inv, claim);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText(claim.parentClaim() != null ? "flan.screenMenuSub" : "flan.screenMenu", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        for (int i = 0; i < 18; ++i) {
            ItemStack stack;
            ClaimAllowListKey<?> val = UI_VALUES.get(i);
            if (val != null) {
                stack = ServerScreenHelper.createStack(val.guiIcon().get(), (Component)ServerScreenHelper.coloredGuiText(val.translationKey(), ChatFormatting.GOLD));
                if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                    ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                }
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 0) {
                stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || UI_VALUES.containsKey(slot);
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        ClaimAllowListKey<?> val = UI_VALUES.get(index);
        if (val != null) {
            if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                player.closeContainer();
                player.getServer().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, val, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            } else {
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }
        } else if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
        return true;
    }

    private boolean hasPerm(Claim claim, ServerPlayer player, ResourceLocation perm) {
        if (claim.parentClaim() != null) {
            return claim.parentClaim().canInteract(player, perm, player.blockPosition());
        }
        return claim.canInteract(player, perm, player.blockPosition());
    }
}

