/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ConfirmScreenHandler
extends ServerOnlyScreenHandler<Object> {
    private final Consumer<Boolean> cons;

    private ConfirmScreenHandler(int syncId, Inventory playerInventory, Consumer<Boolean> cons) {
        super(syncId, playerInventory, 1, null);
        this.cons = cons;
    }

    public static void openConfirmScreen(ServerPlayer player, final Consumer<Boolean> process) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ConfirmScreenHandler(syncId, inv, process);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText("flan.screenConfirm", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        block4: for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            switch (i) {
                case 3: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.GREEN_WOOL, (Component)ServerScreenHelper.coloredGuiText("flan.screenYes", ChatFormatting.GREEN));
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block4;
                }
                case 5: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.RED_WOOL, (Component)ServerScreenHelper.coloredGuiText("flan.screenNo", ChatFormatting.RED));
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block4;
                }
                default: {
                    ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 3 || slot == 5;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        switch (index) {
            case 3: {
                this.cons.accept(true);
                break;
            }
            case 5: {
                this.cons.accept(false);
            }
        }
        return true;
    }
}

