/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimGroup;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;

public class GroupPlayerScreenHandler
extends PagedServerOnlyScreenHandler<ClaimGroup> {
    private boolean removeMode;

    private GroupPlayerScreenHandler(int syncId, Inventory playerInventory, final Claim claim, final String group) {
        super(syncId, playerInventory, 6, new ClaimGroup(){

            @Override
            public Claim getClaim() {
                return claim;
            }

            @Override
            public String getGroup() {
                return group;
            }
        });
    }

    public static void openPlayerGroupMenu(Player player, final Claim claim, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new GroupPlayerScreenHandler(syncId, inv, claim, group);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText("flan.screenGroupPlayers", group);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        List<GameProfile> players = ((ClaimGroup)this.data).getClaim().playersFromGroup(this.player.getServer(), ((ClaimGroup)this.data).getGroup());
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 3) {
                ItemStack stack = ServerScreenHelper.createStack(Items.ANVIL, (Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < players.size()) {
                ItemStack stack = ServerScreenHelper.createStack(Items.PLAYER_HEAD, null);
                stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(players.get(id)));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, ((ClaimGroup)this.data).getClaim()));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.closeContainer();
            player.getServer().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                boolean fl = player.getServer().getProfileCache().get(s).map(prof -> ((ClaimGroup)this.data).getClaim().setPlayerGroup(prof.getId(), ((ClaimGroup)this.data).getGroup(), false)).orElse(true);
                player.closeContainer();
                player.getServer().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, ((ClaimGroup)this.data).getClaim(), ((ClaimGroup)this.data).getGroup()));
                if (fl) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
                } else {
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerGroupAddFail", ChatFormatting.RED), false);
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                }
            }, () -> {
                player.closeContainer();
                player.getServer().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, ((ClaimGroup)this.data).getClaim(), ((ClaimGroup)this.data).getGroup()));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
            slot.set(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.getItem();
        if (!stack.isEmpty()) {
            ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
            if (this.removeMode && profile != null && profile.id().isPresent()) {
                ((ClaimGroup)this.data).getClaim().setPlayerGroup(profile.gameProfile().getId(), null, false);
                slot.set(ItemStack.EMPTY);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.BAT_DEATH, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((ClaimGroup)this.data).getClaim().playersFromGroup(this.player.getServer(), ((ClaimGroup)this.data).getGroup()).size() - 1) / 28, 47, 51);
    }
}

