/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.mixin.AbstractContainerAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class PagedServerOnlyScreenHandler<T>
extends ServerOnlyScreenHandler<T> {
    private int page;

    protected PagedServerOnlyScreenHandler(int syncId, Inventory playerInventory, int rows, T additionalData) {
        super(syncId, playerInventory, rows, additionalData);
    }

    @Override
    protected final void setupGui() {
        ItemStack stack;
        super.setupGui();
        PageSettings settings = this.pageSettings();
        if (this.page >= 1 && settings.previousSlot() != -1) {
            stack = ServerScreenHelper.createStack(Items.ARROW, (Component)ServerScreenHelper.coloredGuiText("flan.screenPrevious", ChatFormatting.WHITE));
            ((Slot)this.slots.get(settings.previousSlot())).set(stack);
        }
        if (this.page < settings.maxPages() && settings.nextSlot() != -1) {
            stack = ServerScreenHelper.createStack(Items.ARROW, (Component)ServerScreenHelper.coloredGuiText("flan.screenNext", ChatFormatting.WHITE));
            ((Slot)this.slots.get(settings.nextSlot())).set(stack);
        }
    }

    @Override
    public void clicked(int i, int j, ClickType clickType, Player player) {
        if (this.handlePageFlip(i)) {
            for (ContainerListener listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
                listener.slotChanged((AbstractContainerMenu)this, i, ((Slot)this.slots.get(i)).getItem().copy());
            }
            return;
        }
        super.clicked(i, j, clickType, player);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        if (index < 0) {
            return ItemStack.EMPTY;
        }
        if (this.handlePageFlip(index)) {
            return ((Slot)this.slots.get(index)).getItem().copy();
        }
        return super.quickMoveStack(player, index);
    }

    private boolean handlePageFlip(int slot) {
        boolean next;
        PageSettings settings = this.pageSettings();
        boolean previous = this.page > 0 && settings.previousSlot() != -1 && slot == settings.previousSlot();
        boolean bl = next = this.page < settings.maxPages() && settings.nextSlot() != -1 && slot == settings.nextSlot();
        if (previous || next) {
            if (previous) {
                this.flipPrevious();
            } else {
                this.flipNext();
            }
            return true;
        }
        return false;
    }

    protected abstract PageSettings pageSettings();

    public int getPage() {
        return this.page;
    }

    public void flipNext() {
        this.page = Math.min(this.pageSettings().maxPages(), ++this.page);
        ServerScreenHelper.playSongToPlayer(this.player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.setupGui();
        this.broadcastChanges();
    }

    public void flipPrevious() {
        this.page = Math.max(0, --this.page);
        ServerScreenHelper.playSongToPlayer(this.player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.setupGui();
        this.broadcastChanges();
    }

    public record PageSettings(int maxPages, int previousSlot, int nextSlot) {
    }
}

