/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.mixin;

import io.github.flemmli97.flan.event.PlayerEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SculkSensorBlock.class})
public abstract class SculkSensorMixin {
    @Inject(method={"activate"}, at={@At(value="HEAD")}, cancellable=true)
    private void playerPermCheck(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int power, int frequency, CallbackInfo info) {
        ItemEntity item;
        Projectile proj;
        Entity entity2;
        ServerPlayer player = null;
        if (entity instanceof ServerPlayer) {
            ServerPlayer p;
            player = p = (ServerPlayer)entity;
        } else if (entity instanceof Projectile && (entity2 = (proj = (Projectile)entity).getOwner()) instanceof ServerPlayer) {
            ServerPlayer p;
            player = p = (ServerPlayer)entity2;
        } else if (entity instanceof ItemEntity && (entity2 = (item = (ItemEntity)entity).getOwner()) instanceof ServerPlayer) {
            ServerPlayer p;
            player = p = (ServerPlayer)entity2;
        }
        if (player != null && !PlayerEvents.canSculkTrigger(pos, player)) {
            info.cancel();
        }
    }
}

