/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.permissions;

import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.config.ConfigHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public interface PermissionNodeHandler {
    public static final String CMD_RELOAD = "flan.command.reload";
    public static final String CMD_GRIEF_PREVENTION = "flan.command.read.griefprevention";
    public static final String CLAIM_CREATE = "flan.claim.create";
    public static final String CLAIM_ADMIN_CREATE = "flan.claim.admin.create";
    public static final String CMD_MENU = "flan.command.menu";
    public static final String CMD_TRAPPED = "flan.command.trapped";
    public static final String CMD_PERSONAL = "flan.command.personal";
    public static final String CMD_INFO = "flan.command.info";
    public static final String CMD_TRANSFER = "flan.command.transfer";
    public static final String CMD_DELETE = "flan.command.delete";
    public static final String CMD_DELETE_ALL = "flan.command.delete.all";
    public static final String CMD_DELETE_SUB = "flan.command.delete.sub";
    public static final String CMD_DELETE_SUB_ALL = "flan.command.delete.sub.all";
    public static final String CMD_LIST = "flan.command.list";
    public static final String CMD_LIST_ALL = "flan.command.list.all";
    public static final String CMD_CLAIM_MODE = "flan.command.claim.mode";
    public static final String CMD_BYPASS_MODE = "flan.command.bypass.claim";
    public static final String CMD_ADMIN_SET = "flan.command.admin.claim";
    public static final String CMD_ADMIN_LIST = "flan.command.admin.list";
    public static final String CMD_ADMIN_DELETE = "flan.command.admin.delete";
    public static final String CMD_ADMIN_GIVE = "flan.command.admin.give";
    public static final String ADMIN_BYPASS = "flan.bypass.admin.mode";
    public static final String CMD_GROUP = "flan.command.group";
    public static final String CMD_FAKE_PLAYER = "flan.command.fakeplayer";
    public static final String CMD_PERMISSION = "flan.command.permission";
    public static final String CMD_CLAIM_IGNORE = "flan.command.claim.ignore";
    public static final String CMD_SELL = "flan.command.sell";
    public static final String CMD_BUY = "flan.command.buy";
    public static final String CMD_UNLOCK_ALL = "flan.command.unlock.all";
    public static final String CMD_NAME = "flan.command.name";
    public static final String CMD_HOME = "flan.command.home";
    public static final String CMD_TELEPORT = "flan.command.teleport";
    public static final String PERM_CLAIM_BLOCKS = "flan.claim.blocks.max";
    public static final String PERM_MAX_CLAIMS = "flan.claims.amount";
    public static final String PERM_CLAIM_BLOCKS_CAP = "flan.claim.blocks.cap";
    public static final String PERM_CLAIM_BLOCKS_BONUS = "flan.claim.blocks.bonus";
    public static final PermissionNodeHandler INSTANCE = Flan.getPlatformInstance(PermissionNodeHandler.class, "io.github.flemmli97.flan.fabric.platform.integration.permissions.PermissionNodeHandlerImpl", "io.github.flemmli97.flan.neoforge.platform.integration.permissions.PermissionNodeHandlerImpl");

    default public boolean perm(CommandSourceStack src, String perm) {
        return this.perm(src, perm, false);
    }

    default public boolean perm(CommandSourceStack src, String perm, boolean adminCmd) {
        Entity entity;
        if (!Flan.ftbRanks || !((entity = src.getEntity()) instanceof ServerPlayer)) {
            return !adminCmd || src.hasPermission(ConfigHandler.CONFIG.permissionLevel);
        }
        ServerPlayer player = (ServerPlayer)entity;
        return FTBRanksAPI.getPermissionValue((ServerPlayer)player, (String)perm).asBoolean().orElse(!adminCmd || player.hasPermissions(ConfigHandler.CONFIG.permissionLevel));
    }

    default public boolean perm(ServerPlayer src, String perm, boolean adminCmd) {
        if (!Flan.ftbRanks) {
            return !adminCmd || src.hasPermissions(ConfigHandler.CONFIG.permissionLevel);
        }
        return FTBRanksAPI.getPermissionValue((ServerPlayer)src, (String)perm).asBoolean().orElse(!adminCmd || src.hasPermissions(ConfigHandler.CONFIG.permissionLevel));
    }

    default public boolean permBelowEqVal(ServerPlayer src, String perm, int val, int fallback) {
        if (Flan.ftbRanks) {
            int max = FTBRanksAPI.getPermissionValue((ServerPlayer)src, (String)perm).asInteger().orElse(fallback);
            return val <= max;
        }
        return val <= fallback;
    }

    default public int permVal(ServerPlayer src, String perm, int fallback) {
        if (Flan.ftbRanks) {
            return FTBRanksAPI.getPermissionValue((ServerPlayer)src, (String)perm).asInteger().orElse(fallback);
        }
        return fallback;
    }
}

