/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.ItemCost;

public record TradeMatcher(TradeFilter filter, OnMatch onMatch) {
    public boolean matchMerchantLevel(int level) {
        if (this.filter.level().isEmpty()) {
            return true;
        }
        return this.filter.level().get().test(level);
    }

    public boolean matchProfession(VillagerProfession profession) {
        if (this.filter.professions().isEmpty()) {
            return true;
        }
        Holder holder = BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)profession);
        return this.filter.professions().get().contains(holder);
    }

    public boolean matchType(TradeTypes type) {
        if (this.filter.types().isEmpty()) {
            return true;
        }
        return this.filter.types().get().contains((Object)type);
    }

    private boolean match(Optional<Ingredient> filter, Optional<IntRange> countFilter, ItemStack itemStack) {
        boolean matchesCount = countFilter.isEmpty() || countFilter.get().test(itemStack.getCount());
        boolean matchesFilter = filter.isEmpty() || filter.get().test(itemStack);
        return matchesCount && matchesFilter;
    }

    public boolean match(ItemStack costA, ItemStack costB, ItemStack output, TradeTypes type) {
        boolean matched;
        boolean firstMatch = this.match(this.filter.first(), this.filter.firstCount(), costA);
        boolean secondMatch = this.match(this.filter.second(), this.filter.secondCount(), costB);
        boolean outputMatch = this.match(this.filter.output(), this.filter.outputCount(), output);
        boolean bl = matched = this.matchType(type) && firstMatch && secondMatch && outputMatch;
        if (matched) {
            this.onMatch.notify(costA, costB, output);
        }
        return matched;
    }

    public boolean match(ItemStack first, ItemStack output, TradeTypes type) {
        return this.match(first, ItemStack.EMPTY, output, type);
    }

    public boolean match(ItemCost costA, Optional<ItemCost> costB, ItemStack output, TradeTypes type) {
        return this.match(costA.itemStack(), costB.map(ItemCost::itemStack).orElse(ItemStack.EMPTY), output, type);
    }

    public boolean match(ItemStack costA, ItemCost costB, ItemStack output, TradeTypes type) {
        return this.match(costA, costB.itemStack(), output, type);
    }

    public boolean match(ItemCost costA, ItemStack output, TradeTypes type) {
        return this.match(costA, Optional.empty(), output, type);
    }

    public static interface OnMatch {
        public void notify(ItemStack var1, @Nullable ItemStack var2, ItemStack var3);
    }

    public static interface Filterable {
        default public boolean matchesTradeFilter(TradeMatcher filter) {
            return false;
        }
    }
}

