/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.mixins;

import com.portingdeadmods.cable_facades.utils.ClientFacadeManager;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.extensions.IBlockStateExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockState.class})
public abstract class BlockStateMixin
extends BlockBehaviour.BlockStateBase
implements IBlockStateExtension {
    @Unique
    private static final ThreadLocal<Boolean> cable_facades$recursionGuard = ThreadLocal.withInitial(() -> false);

    @Shadow
    protected abstract BlockState asState();

    private BlockStateMixin() {
        super(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockState getAppearance(BlockAndTintGetter blockGetter, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return this.getBlock().getAppearance(this.asState(), blockGetter, pos, side, queryState, queryPos);
        }
        cable_facades$recursionGuard.set(true);
        try {
            BlockState facadeState;
            if (ClientFacadeManager.FACADED_BLOCKS.containsKey(pos) && (facadeState = ClientFacadeManager.FACADED_BLOCKS.get(pos)) != null) {
                BlockState blockState = facadeState.getBlock().getAppearance(facadeState, blockGetter, pos, side, queryState, queryPos);
                return blockState;
            }
            BlockState blockState = this.getBlock().getAppearance(this.asState(), blockGetter, pos, side, queryState, queryPos);
            return blockState;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightEmission(BlockGetter blockGetter, BlockPos pos) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return this.getBlock().getLightEmission(this.asState(), blockGetter, pos);
        }
        cable_facades$recursionGuard.set(true);
        try {
            BlockState facadeState;
            if (FacadeUtils.hasFacade(blockGetter, pos) && (facadeState = FacadeUtils.getFacade(blockGetter, pos)) != null) {
                int n = facadeState.getLightEmission();
                return n;
            }
            int n = this.getBlock().getLightEmission(this.asState(), blockGetter, pos);
            return n;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFaceSturdy(BlockGetter level, BlockPos pos, Direction direction, SupportType supportType) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return super.isFaceSturdy(level, pos, direction, supportType);
        }
        cable_facades$recursionGuard.set(true);
        try {
            BlockState facadeState;
            if (FacadeUtils.hasFacade(level, pos) && (facadeState = FacadeUtils.getFacade(level, pos)) != null) {
                boolean bl = facadeState.isFaceSturdy(level, BlockPos.ZERO, direction, supportType);
                return bl;
            }
            boolean bl = super.isFaceSturdy(level, pos, direction, supportType);
            return bl;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoxelShape getVisualShape(BlockGetter level, BlockPos pos, CollisionContext context) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return super.getVisualShape(level, pos, context);
        }
        cable_facades$recursionGuard.set(true);
        try {
            BlockState facadeState;
            if (FacadeUtils.hasFacade(level, pos) && (facadeState = FacadeUtils.getFacade(level, pos)) != null) {
                VoxelShape voxelShape = facadeState.getVisualShape(level, BlockPos.ZERO, context);
                return voxelShape;
            }
            VoxelShape voxelShape = super.getVisualShape(level, pos, context);
            return voxelShape;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightBlock(BlockGetter level, BlockPos pos) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return super.getLightBlock(level, pos);
        }
        cable_facades$recursionGuard.set(true);
        try {
            if (FacadeUtils.hasFacade(level, pos) && this.asState().getBlock().asItem().getDescriptionId().contains("create")) {
                int n = 0;
                return n;
            }
            int n = super.getLightBlock(level, pos);
            return n;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }
}

