/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.mixins;

import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public class StructureTemplateMixin {
    @Unique
    private static final String FACADES_TAG = "cable_facades";
    @Unique
    private final Map<BlockPos, BlockState> facadeMap = new HashMap<BlockPos, BlockState>();

    @Inject(method={"fillFromWorld"}, at={@At(value="RETURN")})
    private void onFillFromWorld(Level level, BlockPos pos, Vec3i size, boolean includeEntities, Block toIgnore, CallbackInfo ci) {
        this.facadeMap.clear();
        BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(size).offset(-1, -1, -1)).forEach(blockPos -> {
            BlockState facade = FacadeUtils.getFacade((BlockGetter)level, blockPos);
            if (facade != null) {
                BlockPos relativePos = blockPos.subtract((Vec3i)pos);
                this.facadeMap.put(relativePos, facade);
            }
        });
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    private void onSave(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        if (!this.facadeMap.isEmpty()) {
            ListTag facadesTag = new ListTag();
            this.facadeMap.forEach((pos, state) -> {
                CompoundTag facadeTag = new CompoundTag();
                facadeTag.put("pos", NbtUtils.writeBlockPos((BlockPos)pos));
                facadeTag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)state));
                facadesTag.add((Object)facadeTag);
            });
            tag.put(FACADES_TAG, (Tag)facadesTag);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(HolderGetter<Block> blockGetter, CompoundTag tag, CallbackInfo ci) {
        this.facadeMap.clear();
        if (tag.contains(FACADES_TAG, 9)) {
            ListTag facadesTag = tag.getList(FACADES_TAG, 10);
            for (int i = 0; i < facadesTag.size(); ++i) {
                CompoundTag facadeTag = facadesTag.getCompound(i);
                Optional posOpt = NbtUtils.readBlockPos((CompoundTag)facadeTag, (String)"pos");
                if (!posOpt.isPresent()) continue;
                BlockPos pos = (BlockPos)posOpt.get();
                BlockState state = NbtUtils.readBlockState(blockGetter, (CompoundTag)facadeTag.getCompound("state"));
                this.facadeMap.put(pos, state);
            }
        }
    }

    @Inject(method={"placeInWorld"}, at={@At(value="RETURN")})
    private void onPlaceInWorld(ServerLevelAccessor level, BlockPos offset, BlockPos pos, StructurePlaceSettings settings, RandomSource random, int flags, CallbackInfoReturnable<Boolean> cir) {
        if (!this.facadeMap.isEmpty() && ((Boolean)cir.getReturnValue()).booleanValue()) {
            this.facadeMap.forEach((relativePos, facadeState) -> {
                BlockPos transformedPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)relativePos);
                BlockPos actualPos = transformedPos.offset((Vec3i)offset);
                BlockState transformedState = facadeState.mirror(settings.getMirror()).rotate(settings.getRotation());
                FacadeUtils.addFacade((Level)level.getLevel(), actualPos, transformedState);
            });
        }
    }
}

