/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.base;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.energy.EnergyStorage;

public class PylonEnergyStorage
extends EnergyStorage {
    private final Runnable listener;

    public PylonEnergyStorage(Runnable listener, int capacity, int maxRecieve) {
        super(capacity, maxRecieve, 0);
        this.listener = listener;
    }

    public void onEnergyChanged() {
        this.listener.run();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int rc = super.receiveEnergy(maxReceive, simulate);
        if (rc > 0 && !simulate) {
            this.onEnergyChanged();
        }
        return rc;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int rc = super.extractEnergy(maxExtract, simulate);
        if (rc > 0 && !simulate) {
            this.onEnergyChanged();
        }
        return rc;
    }

    public boolean consumeEnergy(int request, boolean simulate) {
        int consumed = Math.max(0, request);
        if (this.energy > consumed) {
            if (!simulate) {
                this.energy -= consumed;
                this.onEnergyChanged();
            }
            return true;
        }
        return false;
    }

    public void deserializeNBT(HolderLookup.Provider provider, @Nullable Tag nbt) {
        if (nbt != null) {
            super.deserializeNBT(provider, nbt);
        }
    }
}

