/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.expulsion;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.PlayerComponent;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.TranslationKey;

public class ExpulsionPylonTile
extends AbstractPylonTile {
    private List<ResourceKey<Level>> allowedDimensions = null;

    public ExpulsionPylonTile(BlockPos pos, BlockState state) {
        super(ModRegistry.EXPULSION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{1, 3, 5};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.getItem() instanceof PlayerFilterCard;
    }

    protected AABB getBoundingBox(ServerLevel level) {
        Integer maxRadius;
        ChunkPos chunkPos = level.getChunkAt(this.worldPosition).getPos();
        AABB aabb = new AABB((double)chunkPos.getMinBlockX(), (double)level.getMinBuildHeight(), (double)chunkPos.getMinBlockZ(), (double)chunkPos.getMaxBlockX() + 1.0, (double)level.getMaxBuildHeight() + 1.0, (double)chunkPos.getMaxBlockZ() + 1.0);
        int selected = this.range.get() - 1;
        if (selected > (maxRadius = (Integer)ConfigManager.SERVER.expulsionPylonMaxRadius.get())) {
            selected = maxRadius;
        }
        if (selected > 0) {
            return aabb.inflate((double)selected * 8.0);
        }
        return aabb;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            AABB aabb;
            List players;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(10) && this.owner != null && this.isAllowedDimension() && this.isAllowedLocation() && !(players = serverLevel.getEntitiesOfClass(ServerPlayer.class, aabb = this.getBoundingBox(serverLevel))).isEmpty()) {
                List<UUID> allowed = this.allowedPlayers();
                for (ServerPlayer player : players) {
                    if (this.canAccess((Player)player) || allowed.contains(player.getUUID())) continue;
                    this.doRespawn(serverLevel.getServer(), player);
                }
            }
        }
    }

    @Override
    public void updateContainer(FriendlyByteBuf packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.writeBoolean(this.isAllowedDimension());
        packetBuffer.writeBoolean(this.isAllowedLocation());
    }

    public boolean isAllowedDimension() {
        if (this.level != null) {
            if (this.allowedDimensions == null) {
                ArrayList<ResourceKey> temp = new ArrayList<ResourceKey>();
                List allowed = (List)ConfigManager.SERVER.expulsionAllowedDimensions.get();
                for (String key : allowed) {
                    temp.add(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)key)));
                }
                this.allowedDimensions = ImmutableList.copyOf(temp);
            }
            return this.allowedDimensions.contains(this.level.dimension());
        }
        return false;
    }

    public boolean isAllowedLocation() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            AABB workArea;
            ServerLevel serverLevel = (ServerLevel)level;
            int spawnRadius = serverLevel.getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS);
            int configRadius = (Integer)ConfigManager.SERVER.expulsionWorldSpawnRadius.get();
            AABB bb = new AABB(serverLevel.getSharedSpawnPos());
            AABB area = bb.inflate((double)Math.max(configRadius, spawnRadius));
            return !area.intersects(workArea = this.getBoundingBox(serverLevel));
        }
        return false;
    }

    private List<UUID> allowedPlayers() {
        ArrayList<UUID> allowed = new ArrayList<UUID>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            PlayerComponent data;
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof PlayerFilterCard) || (data = (PlayerComponent)stack.get(ModRegistry.PLAYER_COMPONENT)) == null) continue;
            allowed.add(data.uuid());
        }
        return allowed;
    }

    private void doRespawn(MinecraftServer server, ServerPlayer player) {
        DimensionTransition transition = player.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.DO_NOTHING);
        if (this.getBoundingBox(transition.newLevel()).contains(transition.pos())) {
            return;
        }
        player.teleportTo(transition.newLevel(), transition.pos().x(), transition.pos().y(), transition.pos().z(), transition.yRot(), transition.xRot());
        player.sendSystemMessage((Component)Component.translatable((String)TranslationKey.chat("expelled"), (Object[])new Object[]{this.getOwnerName()}).withStyle(ChatFormatting.RED));
    }
}

