/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.util;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.util.Location;
import net.permutated.pylons.util.ResourceUtil;

@EventBusSubscriber(modid="pylons")
public class ChunkManager {
    private static final Map<UUID, Location> loaded = new ConcurrentHashMap<UUID, Location>();
    private static final Map<UUID, Location> unloaded = new ConcurrentHashMap<UUID, Location>();
    private static final TicketController controller = new TicketController(ResourceUtil.prefix("block"), ChunkManager::validateTickets);

    private ChunkManager() {
    }

    public static void onRegisterTicketControllersEvent(RegisterTicketControllersEvent event) {
        event.register(controller);
    }

    @SubscribeEvent
    public static void beforeServerStopped(ServerStoppingEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void afterServerStarted(ServerStartedEvent event) {
        loaded.clear();
        unloaded.clear();
    }

    @SubscribeEvent
    public static void onLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        UUID uuid = event.getEntity().getUUID();
        if (uuid != null && unloaded.containsKey(uuid)) {
            ServerLevel level;
            Location location = unloaded.get(uuid);
            MinecraftServer server = event.getEntity().getServer();
            if (location != null && server != null && (level = server.getLevel(location.level())) != null) {
                ChunkManager.loadChunk(uuid, level, location.blockPos());
            }
        }
    }

    @SubscribeEvent
    public static void onLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getEntity().getUUID();
        if (uuid != null && loaded.containsKey(uuid)) {
            ServerLevel level;
            Location location = loaded.get(uuid);
            MinecraftServer server = event.getEntity().getServer();
            if (location != null && server != null && (level = server.getLevel(location.level())) != null) {
                ChunkManager.unloadChunk(uuid, level, location.blockPos());
            }
        }
    }

    public static void loadChunk(UUID owner, ServerLevel level, BlockPos pos) {
        if (Boolean.TRUE.equals(ConfigManager.SERVER.infusionChunkloads.get()) && !loaded.containsKey(owner)) {
            Location location = Location.of(level, pos);
            unloaded.remove(owner, location);
            loaded.put(owner, location);
            controller.forceChunk(level, pos, location.chunkX(), location.chunkZ(), true, false);
        }
    }

    public static void unloadChunk(UUID owner, ServerLevel level, BlockPos pos) {
        Location location = Location.of(level, pos);
        loaded.remove(owner, location);
        unloaded.put(owner, location);
        controller.forceChunk(level, pos, location.chunkX(), location.chunkZ(), false, false);
    }

    public static void validateTickets(ServerLevel level, TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((TicketHelper)ticketHelper).removeAllTickets(arg_0));
    }
}

