/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import observable.Observable;
import observable.Props;
import observable.net.BetterChannel;
import observable.net.S2CPacket;
import observable.server.DataWithDiagnostics;
import observable.server.DiagnosticsKt;
import observable.server.ProfilingData;
import observable.server.ServerSettingsKt;
import observable.server.TaggedSampler;
import observable.server.TraceMap;
import observable.shadow.kotlinx.serialization.protobuf.ProtoBuf;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0001_B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010 \u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u001f2\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u001f\u00a2\u0006\u0004\b$\u0010\u0003J\u001f\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b*\u0010+R@\u0010.\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060,0,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00108\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u0010#R$\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010?\u001a\u00020>8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\"\u0010E\u001a\u00020>8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bE\u0010@\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR\"\u0010I\u001a\u00020H8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\"\u0010P\u001a\u00020O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\"\u0010V\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R.\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010/\u001a\u0004\b]\u00101\"\u0004\b^\u00103\u00a8\u0006`"}, d2={"Lobservable/server/Profiler;", "", "<init>", "()V", "Lnet/minecraft/world/entity/Entity;", "entity", "Lobservable/server/Profiler$TimingData;", "process", "(Lnet/minecraft/world/entity/Entity;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/Level;", "level", "processBlock", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/block/entity/TickingBlockEntity;", "blockEntity", "processBlockEntity", "(Lnet/minecraft/world/level/block/entity/TickingBlockEntity;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/world/level/material/FluidState;", "fluidState", "processFluid", "(Lnet/minecraft/world/level/material/FluidState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Lobservable/server/Profiler$TimingData;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "duration", "", "sample", "", "runWithDuration", "(Lnet/minecraft/server/level/ServerPlayer;IZ)V", "startRunning", "(Z)V", "stopRunning", "Lobservable/server/ProfilingData;", "data", "Lkotlinx/serialization/json/JsonObject;", "diagnostics", "", "uploadProfile", "(Lobservable/server/ProfilingData;Lkotlinx/serialization/json/JsonObject;)Ljava/lang/String;", "Ljava/util/HashMap;", "Lnet/minecraft/resources/ResourceKey;", "blockTimingsMap", "Ljava/util/HashMap;", "getBlockTimingsMap", "()Ljava/util/HashMap;", "setBlockTimingsMap", "(Ljava/util/HashMap;)V", "v", "getNotProcessing", "()Z", "setNotProcessing", "notProcessing", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "setPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Ljava/lang/Thread;", "samplerThread", "Ljava/lang/Thread;", "getSamplerThread", "()Ljava/lang/Thread;", "setSamplerThread", "(Ljava/lang/Thread;)V", "serverThread", "getServerThread", "setServerThread", "Lobservable/server/TraceMap;", "serverTraceMap", "Lobservable/server/TraceMap;", "getServerTraceMap", "()Lobservable/server/TraceMap;", "setServerTraceMap", "(Lobservable/server/TraceMap;)V", "", "startTime", "J", "getStartTime", "()J", "setStartTime", "(J)V", "startingTicks", "I", "getStartingTicks", "()I", "setStartingTicks", "(I)V", "timingsMap", "getTimingsMap", "setTimingsMap", "TimingData", "observable"})
@SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\nobservable/server/Profiler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 BetterChannel.kt\nobservable/net/BetterChannel\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 TraceMap.kt\nobservable/server/TraceMap\n*L\n1#1,187:1\n372#2,7:188\n372#2,7:195\n372#2,7:202\n372#2,7:209\n372#2,7:216\n372#2,7:223\n372#2,7:230\n372#2,7:314\n74#3:237\n75#3:240\n77#3:242\n34#3:243\n73#3,6:245\n74#3:253\n75#3:256\n77#3:258\n34#3:259\n73#3,6:261\n80#3:271\n74#3:272\n75#3:275\n77#3:277\n34#3:278\n73#3,6:280\n74#3:289\n75#3:292\n77#3:294\n34#3:295\n73#3,6:297\n766#4:238\n857#4:239\n858#4:241\n766#4:254\n857#4:255\n858#4:257\n1549#4:267\n1620#4,3:268\n766#4:273\n857#4:274\n858#4:276\n766#4:286\n857#4,2:287\n766#4:290\n857#4:291\n858#4:293\n186#5:244\n113#5:251\n186#5:260\n186#5:279\n186#5:296\n1#6:252\n30#7,11:303\n41#7,4:321\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\nobservable/server/Profiler\n*L\n56#1:188,7\n60#1:195,7\n61#1:202,7\n72#1:209,7\n73#1:216,7\n84#1:223,7\n85#1:230,7\n111#1:314,7\n127#1:237\n127#1:240\n127#1:242\n127#1:243\n127#1:245,6\n173#1:253\n173#1:256\n173#1:258\n173#1:259\n173#1:261,6\n178#1:271\n178#1:272\n178#1:275\n178#1:277\n178#1:278\n178#1:280,6\n184#1:289\n184#1:292\n184#1:294\n184#1:295\n184#1:297,6\n127#1:238\n127#1:239\n127#1:241\n173#1:254\n173#1:255\n173#1:257\n176#1:267\n176#1:268,3\n178#1:273\n178#1:274\n178#1:276\n183#1:286\n183#1:287,2\n184#1:290\n184#1:291\n184#1:293\n127#1:244\n143#1:251\n173#1:260\n178#1:279\n184#1:296\n111#1:303,11\n111#1:321,4\n*E\n"})
public final class Profiler {
    @NotNull
    private HashMap<Entity, TimingData> timingsMap = new HashMap();
    public TraceMap serverTraceMap;
    public Thread serverThread;
    public Thread samplerThread;
    @NotNull
    private HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> blockTimingsMap = new HashMap();
    @Nullable
    private ServerPlayer player;
    private long startTime;
    private int startingTicks;

    @NotNull
    public final HashMap<Entity, TimingData> getTimingsMap() {
        return this.timingsMap;
    }

    public final void setTimingsMap(@NotNull HashMap<Entity, TimingData> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.timingsMap = hashMap;
    }

    @NotNull
    public final TraceMap getServerTraceMap() {
        TraceMap traceMap = this.serverTraceMap;
        if (traceMap != null) {
            return traceMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverTraceMap");
        return null;
    }

    public final void setServerTraceMap(@NotNull TraceMap traceMap) {
        Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
        this.serverTraceMap = traceMap;
    }

    @NotNull
    public final Thread getServerThread() {
        Thread thread = this.serverThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverThread");
        return null;
    }

    public final void setServerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.serverThread = thread;
    }

    @NotNull
    public final Thread getSamplerThread() {
        Thread thread = this.samplerThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"samplerThread");
        return null;
    }

    public final void setSamplerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.samplerThread = thread;
    }

    @NotNull
    public final HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> getBlockTimingsMap() {
        return this.blockTimingsMap;
    }

    public final void setBlockTimingsMap(@NotNull HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.blockTimingsMap = hashMap;
    }

    public final boolean getNotProcessing() {
        return Props.notProcessing;
    }

    public final void setNotProcessing(boolean v) {
        Props.notProcessing = v;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ServerPlayer serverPlayer) {
        this.player = serverPlayer;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final int getStartingTicks() {
        return this.startingTicks;
    }

    public final void setStartingTicks(int n) {
        this.startingTicks = n;
    }

    @NotNull
    public final TimingData process(@NotNull Entity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map $this$getOrPut$iv = this.timingsMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(entity);
        if (value$iv == null) {
            boolean bl = false;
            TimingData answer$iv = new TimingData(0L, 0, new TraceMap(Reflection.getOrCreateKotlinClass(entity.getClass())), null, 8, null);
            $this$getOrPut$iv.put(entity, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlockEntity(@NotNull TickingBlockEntity blockEntity, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        BlockPos blockPos = blockEntity.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        key$iv = blockPos;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockEntity.getClass()));
            String string = blockEntity.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlock(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockState.getClass()));
            String string = blockState.getBlock().getDescriptionId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptionId(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processFluid(@NotNull FluidState fluidState, @NotNull BlockPos pos, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map = this.blockTimingsMap;
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(fluidState.getClass()));
            String string = BuiltInRegistries.FLUID.getKey((Object)fluidState.getType()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning(boolean sample) {
        this.timingsMap.clear();
        this.blockTimingsMap.clear();
        this.setServerTraceMap(new TraceMap(null, null, null, 0, 15, null));
        this.startTime = System.currentTimeMillis();
        Boolean bl = Props.notProcessing;
        synchronized (bl) {
            boolean bl2 = false;
            this.setNotProcessing(false);
            MinecraftServer minecraftServer = GameInstance.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            this.startingTicks = minecraftServer.getTickCount();
            Unit unit = Unit.INSTANCE;
        }
        if (sample) {
            this.setSamplerThread(new Thread(new TaggedSampler(this.getServerThread())));
            this.getSamplerThread().start();
            new Thread(() -> Profiler.startRunning$lambda$8(this)).start();
        }
    }

    public static /* synthetic */ void startRunning$default(Profiler profiler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        profiler.startRunning(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void runWithDuration(@Nullable ServerPlayer player, int duration, boolean sample) {
        void this_$iv$iv;
        void msg$iv;
        void this_$iv;
        void $this$filterTo$iv$iv$iv;
        void players$iv;
        this.player = player;
        this.startRunning(sample);
        long durMs = (long)duration * 1000L;
        Object object = Observable.INSTANCE.getCHANNEL();
        MinecraftServer minecraftServer = GameInstance.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        List list = minecraftServer.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Object object2 = list;
        S2CPacket.ProfilingStarted profilingStarted = new S2CPacket.ProfilingStarted(this.startTime + durMs);
        boolean $i$f$sendToPlayers = false;
        void $this$filter$iv$iv = players$iv;
        boolean $i$f$filter = false;
        void var12_12 = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            ServerPlayer it$iv = (ServerPlayer)element$iv$iv$iv;
            boolean bl = false;
            if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv, (ResourceLocation)this_$iv.getS2cLocation())) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv$iv;
        $this$filter$iv$iv = this_$iv;
        NetworkManager.Side side$iv$iv = NetworkManager.Side.S2C;
        boolean $i$f$createPayload = false;
        String string = S2CPacket.ProfilingStarted.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BinaryFormat $this$encodeToByteArray$iv$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        $this$encodeToByteArray$iv$iv$iv.getSerializersModule();
        NetworkManager.sendToPlayers((Iterable)iterable, (CustomPacketPayload)new BetterChannel.SerializedPayload(string, $this$encodeToByteArray$iv$iv$iv.encodeToByteArray((SerializationStrategy)S2CPacket.ProfilingStarted.Companion.serializer(), (Object)msg$iv), side$iv$iv == NetworkManager.Side.S2C ? this_$iv$iv.getS2cLocation() : this_$iv$iv.getC2sLocation()));
        object = new Timer("Profiler", false);
        object2 = new TimerTask(this){
            final /* synthetic */ Profiler this$0;
            {
                this.this$0 = profiler;
            }

            public void run() {
                TimerTask $this$runWithDuration_u24lambda_u249 = this;
                boolean bl = false;
                this.this$0.stopRunning();
            }
        };
        ((Timer)object).schedule((TimerTask)object2, durMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final String uploadProfile(@NotNull ProfilingData data, @NotNull JsonObject diagnostics) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
        if (((CharSequence)ServerSettingsKt.getServerSettings().getUploadURL()).length() == 0) {
            Observable.INSTANCE.getLOGGER().info("uploadURL not set, skipping upload");
            return null;
        }
        Observable.INSTANCE.getLOGGER().info("Attempting to upload profile");
        Object object = (StringFormat)Json.Default;
        Object value$iv = new DataWithDiagnostics(data, diagnostics);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String serialized = $this$encodeToString$iv.encodeToString((SerializationStrategy)DataWithDiagnostics.Companion.serializer(), value$iv);
        try {
            String string;
            URLConnection uRLConnection = new URL(ServerSettingsKt.getServerSettings().getUploadURL()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            Logger logger = Observable.INSTANCE.getLOGGER();
            Object object2 = "%.2f";
            Object object3 = new Object[]{(double)serialized.length() / 1000.0};
            String string2 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.info("Writing " + string2 + "kb");
            object3 = new OutputStreamWriter((OutputStream)new GZIPOutputStream(conn.getOutputStream()), Charsets.UTF_8);
            int n = 8192;
            value$iv = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter it = (BufferedWriter)value$iv;
                boolean bl = false;
                it.write(serialized);
                object3 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)value$iv, (Throwable)object2);
            }
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object2 = inputStream;
            object3 = Charsets.UTF_8;
            Reader bl = new InputStreamReader((InputStream)object2, (Charset)object3);
            int n2 = 8192;
            object2 = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, n2);
            object3 = null;
            try {
                BufferedReader it = (BufferedReader)object2;
                boolean bl2 = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            String profileURL = string;
            Observable.INSTANCE.getLOGGER().info("Profile uploaded to " + profileURL);
            object = profileURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void stopRunning() {
        block12: {
            void this_$iv$iv;
            void this_$iv;
            void $this$filterTo$iv$iv$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list;
            PlayerList playerList;
            void this_$iv$iv$iv;
            void $this$filterTo$iv$iv$iv$iv;
            void this_$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void this_$iv$iv2;
            void this_$iv3;
            void $this$filterTo$iv$iv$iv2;
            Object object;
            Object object2;
            int ticks;
            JsonObject diagnostics;
            block11: {
                block10: {
                    diagnostics = DiagnosticsKt.getDiagnostics(this);
                    ticks = 0;
                    object2 = Props.notProcessing;
                    synchronized (object2) {
                        boolean $i$a$-synchronized-Profiler$stopRunning$22 = false;
                        this.setNotProcessing(true);
                        MinecraftServer minecraftServer = GameInstance.getServer();
                        Intrinsics.checkNotNull((Object)minecraftServer);
                        ticks = minecraftServer.getTickCount() - this.startingTicks;
                        Unit $i$a$-synchronized-Profiler$stopRunning$22 = Unit.INSTANCE;
                    }
                    object = this.player;
                    if (object == null) break block10;
                    ServerPlayer it = object;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it);
                    object = list2;
                    if (list2 != null) break block11;
                }
                object = CollectionsKt.emptyList();
            }
            Object players = object;
            object2 = Observable.INSTANCE.getCHANNEL();
            Object msg$iv = S2CPacket.ProfilingCompleted.INSTANCE;
            boolean $i$f$sendToPlayers = false;
            Iterable $this$filter$iv$iv = (Iterable)players;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
                ServerPlayer it$iv = (ServerPlayer)element$iv$iv$iv;
                boolean bl = false;
                if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv, (ResourceLocation)this_$iv3.getS2cLocation())) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv$iv;
            $this$filter$iv$iv = this_$iv3;
            NetworkManager.Side side$iv$iv = NetworkManager.Side.S2C;
            boolean $i$f$createPayload = false;
            String string = S2CPacket.ProfilingCompleted.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BinaryFormat $this$encodeToByteArray$iv$iv$iv = ProtoBuf.Default;
            boolean $i$f$encodeToByteArray = false;
            $this$encodeToByteArray$iv$iv$iv.getSerializersModule();
            NetworkManager.sendToPlayers((Iterable)iterable2, (CustomPacketPayload)new BetterChannel.SerializedPayload(string, $this$encodeToByteArray$iv$iv$iv.encodeToByteArray((SerializationStrategy)S2CPacket.ProfilingCompleted.INSTANCE.serializer(), msg$iv), side$iv$iv == NetworkManager.Side.S2C ? this_$iv$iv2.getS2cLocation() : this_$iv$iv2.getC2sLocation()));
            ProfilingData data = ProfilingData.Companion.create((Map<Entity, TimingData>)this.timingsMap, (Map<ResourceKey<Level>, ? extends Map<BlockPos, TimingData>>)this.blockTimingsMap, ticks, this.getServerTraceMap());
            Observable.INSTANCE.getLOGGER().info("Profiler ran for " + ticks + " ticks, sending data");
            msg$iv = (Iterable)players;
            Logger logger = Observable.INSTANCE.getLOGGER();
            boolean $i$f$map22 = false;
            this_$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ServerPlayer serverPlayer = (ServerPlayer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGameProfile().getName());
            }
            logger.info("Sending to " + (List)destination$iv$iv);
            String link = this.uploadProfile(data, diagnostics);
            BetterChannel $i$f$map22 = Observable.INSTANCE.getCHANNEL();
            S2CPacket.ProfilingResult msg$iv2 = new S2CPacket.ProfilingResult(data, link);
            boolean $i$f$sendToPlayersSplit = false;
            void this_$iv$iv3 = this_$iv2;
            boolean $i$f$sendToPlayers22 = false;
            Iterable $this$filter$iv$iv$iv = (Iterable)players;
            boolean $i$f$filter2 = false;
            Iterable bl = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                ServerPlayer it$iv$iv = (ServerPlayer)element$iv$iv$iv$iv;
                boolean bl2 = false;
                if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv$iv, (ResourceLocation)this_$iv$iv3.getS2cLocation())) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv$iv$iv;
            $this$filter$iv$iv$iv = this_$iv$iv3;
            NetworkManager.Side side$iv$iv$iv = NetworkManager.Side.S2C;
            boolean $i$f$createPayload2 = false;
            String string2 = S2CPacket.ProfilingResult.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            BinaryFormat $this$encodeToByteArray$iv$iv$iv$iv = ProtoBuf.Default;
            boolean $i$f$encodeToByteArray2 = false;
            $this$encodeToByteArray$iv$iv$iv$iv.getSerializersModule();
            NetworkManager.sendToPlayers((Iterable)iterable3, (CustomPacketPayload)new BetterChannel.SerializedPayload(string2, $this$encodeToByteArray$iv$iv$iv$iv.encodeToByteArray((SerializationStrategy)S2CPacket.ProfilingResult.Companion.serializer(), (Object)msg$iv2), side$iv$iv$iv == NetworkManager.Side.S2C ? this_$iv$iv$iv.getS2cLocation() : this_$iv$iv$iv.getC2sLocation()));
            Observable.INSTANCE.getLOGGER().info("Data transfer complete!");
            MinecraftServer minecraftServer = GameInstance.getServer();
            if (minecraftServer == null || (playerList = minecraftServer.getPlayerList()) == null || (list = playerList.getPlayers()) == null) break block12;
            Iterable $i$f$sendToPlayers22 = list;
            boolean $i$f$filter3 = false;
            side$iv$iv$iv = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ServerPlayer it = (ServerPlayer)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Observable.INSTANCE.hasPermission((Player)it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List it = (List)destination$iv$iv2;
            boolean bl4 = false;
            destination$iv$iv2 = Observable.INSTANCE.getCHANNEL();
            S2CPacket.ProfilerInactive msg$iv3 = S2CPacket.ProfilerInactive.INSTANCE;
            boolean $i$f$sendToPlayers3 = false;
            Iterable $this$filter$iv$iv2 = it;
            boolean $i$f$filter4 = false;
            Iterable bl3 = $this$filter$iv$iv2;
            Collection destination$iv$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                ServerPlayer it$iv = (ServerPlayer)element$iv$iv$iv;
                boolean bl5 = false;
                if (!NetworkManager.canPlayerReceive((ServerPlayer)it$iv, (ResourceLocation)this_$iv.getS2cLocation())) continue;
                destination$iv$iv$iv2.add(element$iv$iv$iv);
            }
            Iterable iterable4 = (List)destination$iv$iv$iv2;
            $this$filter$iv$iv2 = this_$iv;
            NetworkManager.Side side$iv$iv2 = NetworkManager.Side.S2C;
            boolean $i$f$createPayload3 = false;
            String string3 = S2CPacket.ProfilerInactive.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            BinaryFormat $this$encodeToByteArray$iv$iv$iv2 = ProtoBuf.Default;
            boolean $i$f$encodeToByteArray3 = false;
            $this$encodeToByteArray$iv$iv$iv2.getSerializersModule();
            NetworkManager.sendToPlayers((Iterable)iterable4, (CustomPacketPayload)new BetterChannel.SerializedPayload(string3, $this$encodeToByteArray$iv$iv$iv2.encodeToByteArray((SerializationStrategy)S2CPacket.ProfilerInactive.INSTANCE.serializer(), (Object)msg$iv3), side$iv$iv2 == NetworkManager.Side.S2C ? this_$iv$iv.getS2cLocation() : this_$iv$iv.getC2sLocation()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startRunning$lambda$8(Profiler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!Props.notProcessing) {
            long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
            long deviation = ServerSettingsKt.getServerSettings().getDeviation();
            TraceMap traceMap = this$0.getServerTraceMap();
            StackTraceElement[] stackTraceElementArray = this$0.getServerThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Iterator traces$iv = ArraysKt.reversed((Object[])stackTraceElementArray).iterator();
            boolean $i$f$add = false;
            if (traces$iv.hasNext()) {
                void this_$iv;
                this_$iv.setCount(this_$iv.getCount() + 1);
                StackTraceElement tr$iv = (StackTraceElement)traces$iv.next();
                String string = tr$iv.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                this_$iv.setClassName(string);
                String string2 = tr$iv.getMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodName(...)");
                this_$iv.setMethodName(string2);
                TraceMap target$iv = this_$iv;
                while (traces$iv.hasNext()) {
                    TraceMap traceMap2;
                    StackTraceElement el$iv = (StackTraceElement)traces$iv.next();
                    String string3 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethodName(...)");
                    this_$iv.setMethodName(string3);
                    String string4 = el$iv.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getClassName(...)");
                    String string5 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getMethodName(...)");
                    TraceMap.MapKey key$iv = new TraceMap.MapKey(string4, string5);
                    Map<TraceMap.MapKey, TraceMap> $this$getOrPut$iv$iv = target$iv.getChildren();
                    boolean $i$f$getOrPut = false;
                    TraceMap value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl = false;
                        String string6 = el$iv.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getClassName(...)");
                        String string7 = el$iv.getMethodName();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getMethodName(...)");
                        TraceMap answer$iv$iv = new TraceMap(string6, string7, null, 0, 12, null);
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        traceMap2 = answer$iv$iv;
                    } else {
                        traceMap2 = value$iv$iv;
                    }
                    TraceMap traceMap$iv = traceMap2;
                    traceMap$iv.setCount(traceMap$iv.getCount() + 1);
                    target$iv = traceMap$iv;
                }
            }
            Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J8\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000fJ\u0010\u0010\u001b\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0013R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u001c\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010#R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010'R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010\u0011\"\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lobservable/server/Profiler$TimingData;", "", "", "time", "", "ticks", "Lobservable/server/TraceMap;", "traces", "", "name", "<init>", "(JILobservable/server/TraceMap;Ljava/lang/String;)V", "component1", "()J", "component2", "()I", "component3", "()Lobservable/server/TraceMap;", "component4", "()Ljava/lang/String;", "copy", "(JILobservable/server/TraceMap;Ljava/lang/String;)Lobservable/server/Profiler$TimingData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "I", "getTicks", "setTicks", "(I)V", "J", "getTime", "setTime", "(J)V", "Lobservable/server/TraceMap;", "getTraces", "setTraces", "(Lobservable/server/TraceMap;)V", "observable"})
    public static final class TimingData {
        private long time;
        private int ticks;
        @NotNull
        private TraceMap traces;
        @NotNull
        private String name;

        public TimingData(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.time = time;
            this.ticks = ticks;
            this.traces = traces;
            this.name = name;
        }

        public /* synthetic */ TimingData(long l, int n, TraceMap traceMap, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = "";
            }
            this(l, n, traceMap, string);
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public final int getTicks() {
            return this.ticks;
        }

        public final void setTicks(int n) {
            this.ticks = n;
        }

        @NotNull
        public final TraceMap getTraces() {
            return this.traces;
        }

        public final void setTraces(@NotNull TraceMap traceMap) {
            Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
            this.traces = traceMap;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final long component1() {
            return this.time;
        }

        public final int component2() {
            return this.ticks;
        }

        @NotNull
        public final TraceMap component3() {
            return this.traces;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final TimingData copy(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TimingData(time, ticks, traces, name);
        }

        public static /* synthetic */ TimingData copy$default(TimingData timingData, long l, int n, TraceMap traceMap, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = timingData.time;
            }
            if ((n2 & 2) != 0) {
                n = timingData.ticks;
            }
            if ((n2 & 4) != 0) {
                traceMap = timingData.traces;
            }
            if ((n2 & 8) != 0) {
                string = timingData.name;
            }
            return timingData.copy(l, n, traceMap, string);
        }

        @NotNull
        public String toString() {
            return "TimingData(time=" + this.time + ", ticks=" + this.ticks + ", traces=" + this.traces + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.time);
            result = result * 31 + Integer.hashCode(this.ticks);
            result = result * 31 + this.traces.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimingData)) {
                return false;
            }
            TimingData timingData = (TimingData)other;
            if (this.time != timingData.time) {
                return false;
            }
            if (this.ticks != timingData.ticks) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.traces, (Object)timingData.traces)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)timingData.name);
        }
    }
}

