/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.blockentity;

import appeng.api.config.Actionable;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.orientation.BlockOrientation;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import dev.satherov.growthacceleratortiers.block.GATGrowthAcceleratorBlock;
import dev.satherov.growthacceleratortiers.blockentity.GATGrowthAcceleratorBlockEntity;
import dev.satherov.growthacceleratortiers.core.GATConfig;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GATCrankedBlockEntity
extends GATGrowthAcceleratorBlockEntity {
    public static final int MAX_STORED_POWER = GATConfig.instance().getCrankedInternalEnergyMultiplier() * 160;
    public static final int POWER_PER_TICK = GATConfig.instance().getCrankedIdlePowerConsumption();
    public static final double MULTIPLIER = GATConfig.instance().getCrankedSpeedMultiplier();

    public GATCrankedBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(MAX_STORED_POWER, POWER_PER_TICK, MULTIPLIER, blockEntityType, pos, blockState);
        this.setPowerSides(Set.of());
    }

    @Override
    public ICrankable getCrankable(Direction direction) {
        return new AENetworkedPoweredBlockEntity.Crankable((AENetworkedPoweredBlockEntity)this);
    }

    @Override
    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return Set.of();
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.NONE;
    }

    @Override
    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.extractAEPower(POWER_PER_TICK, Actionable.SIMULATE) >= (double)POWER_PER_TICK;
        }
        return (Boolean)this.getBlockState().getValue((Property)GATGrowthAcceleratorBlock.POWERED);
    }
}

