/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.satherov.growthacceleratortiers.core.definitions.GATAttachmentTypes;
import dev.satherov.growthacceleratortiers.data.PositionAttachment;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;

public class GATCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"growthacceleratortiers").then(GATCommands.infoCommand())).then(GATCommands.modifyCommand()));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"gat").then(GATCommands.infoCommand())).then(GATCommands.modifyCommand()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> infoCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(GATCommands::info));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> modifyCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modify").requires(cs -> cs.hasPermission(4))).then(Commands.literal((String)"boosted").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(GATCommands::modifyBoosted))))).then(Commands.literal((String)"directional").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(GATCommands::modifyDirectional))));
    }

    private static int info(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        LevelChunk chunk = level.getChunkAt(pos);
        boolean boosted = chunk.hasData(GATAttachmentTypes.BOOSTED_POSITION.get());
        boolean directional = chunk.hasData(GATAttachmentTypes.DIRECTIONAL_POSITION.get());
        if (!boosted && !directional) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.growthacceleratortiers.no_data"));
            return -1;
        }
        MutableComponent message = Component.translatable((String)"command.growthacceleratortiers.info");
        if (boosted) {
            message.append("\n - ").append((Component)Component.translatable((String)"command.growthacceleratortiers.boosted_position", (Object[])new Object[]{((PositionAttachment)chunk.getData(GATAttachmentTypes.BOOSTED_POSITION.get())).get(pos)}));
        }
        if (directional) {
            message.append("\n - ").append((Component)Component.translatable((String)"command.growthacceleratortiers.directional_position", (Object[])new Object[]{((PositionAttachment)chunk.getData(GATAttachmentTypes.DIRECTIONAL_POSITION.get())).get(pos)}));
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> message, false);
        return 0;
    }

    private static int modifyBoosted(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        LevelChunk chunk = level.getChunkAt(pos);
        if (!chunk.hasData(GATAttachmentTypes.BOOSTED_POSITION.get())) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.growthacceleratortiers.no_data"));
            return -1;
        }
        PositionAttachment data = (PositionAttachment)chunk.getData(GATAttachmentTypes.BOOSTED_POSITION.get());
        MutableComponent message = Component.translatable((String)"command.growthacceleratortiers.modify");
        int before = data.get(pos);
        int after = IntegerArgumentType.getInteger(ctx, (String)"value");
        data.put(pos, after);
        chunk.setUnsaved(true);
        message.append("\n - ").append((Component)Component.translatable((String)"command.growthacceleratortiers.boosted_position", (Object[])new Object[]{before + " -> " + after}));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> message, false);
        return 0;
    }

    private static int modifyDirectional(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        LevelChunk chunk = level.getChunkAt(pos);
        if (!chunk.hasData(GATAttachmentTypes.DIRECTIONAL_POSITION.get())) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.growthacceleratortiers.no_data"));
            return -1;
        }
        PositionAttachment data = (PositionAttachment)chunk.getData(GATAttachmentTypes.DIRECTIONAL_POSITION.get());
        MutableComponent message = Component.translatable((String)"command.growthacceleratortiers.modify");
        int before = data.get(pos);
        int after = IntegerArgumentType.getInteger(ctx, (String)"value");
        data.put(pos, after);
        chunk.setUnsaved(true);
        message.append("\n - ").append((Component)Component.translatable((String)"command.growthacceleratortiers.directional_position", (Object[])new Object[]{before + " -> " + after}));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> message, false);
        return 0;
    }
}

