/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.compat.jade;

import appeng.core.definitions.BlockDefinition;
import dev.satherov.growthacceleratortiers.api.GAT;
import dev.satherov.growthacceleratortiers.block.GATBoostedBlock;
import dev.satherov.growthacceleratortiers.block.GATDirectionalBlock;
import dev.satherov.growthacceleratortiers.block.GATGrowthAcceleratorBlock;
import dev.satherov.growthacceleratortiers.block.GATMonoBlock;
import dev.satherov.growthacceleratortiers.core.annotations.NothingNull;
import dev.satherov.growthacceleratortiers.core.definitions.GATBlocks;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class GATJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)GATComponentProvider.BOOSTED, GATGrowthAcceleratorBlock.class);
        registration.registerBlockComponent((IComponentProvider)GATComponentProvider.DIRECTIONAL, GATDirectionalBlock.class);
    }

    private static void directional(ITooltip tooltip, BlockAccessor accessor) {
        if (!(accessor.getBlock() instanceof GATDirectionalBlock)) {
            return;
        }
        GATDirectionalBlock.Directions direction = (GATDirectionalBlock.Directions)((Object)accessor.getBlockState().getValue(GATDirectionalBlock.DIRECTION));
        boolean conflicted = (Boolean)accessor.getBlockState().getValue((Property)GATMonoBlock.CONFLICTED);
        tooltip.add((Component)Component.translatable((String)"direction.growthacceleratortiers").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("direction.growthacceleratortiers." + direction.name().toLowerCase()))).withStyle(ChatFormatting.GRAY));
        if (conflicted) {
            tooltip.add((Component)Component.translatable((String)"tooltip.growthacceleratortiers.conflicted").withStyle(ChatFormatting.RED));
        }
    }

    private static void boosted(ITooltip tooltip, BlockAccessor accessor) {
        if (!(accessor.getBlock() instanceof GATBoostedBlock)) {
            return;
        }
        boolean conflicted = (Boolean)accessor.getBlockState().getValue((Property)GATMonoBlock.CONFLICTED);
        if (conflicted) {
            tooltip.add((Component)Component.translatable((String)"tooltip.growthacceleratortiers.conflicted").withStyle(ChatFormatting.RED));
        }
    }

    @NothingNull
    static enum GATComponentProvider implements IBlockComponentProvider
    {
        DIRECTIONAL(GATBlocks.DIRECTIONAL_GROWTH_ACCELERATOR, GATJadePlugin::directional),
        BOOSTED(GATBlocks.BOOSTED_GROWTH_ACCELERATOR, GATJadePlugin::boosted);

        final BlockDefinition<? extends GATGrowthAcceleratorBlock<?>> holder;
        final BiConsumer<ITooltip, BlockAccessor> appender;

        private GATComponentProvider(BlockDefinition<? extends GATGrowthAcceleratorBlock<?>> holder, BiConsumer<ITooltip, BlockAccessor> appender) {
            this.holder = holder;
            this.appender = appender;
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            this.appender.accept(tooltip, accessor);
        }

        public ResourceLocation getUid() {
            return GAT.rl(this.holder.id().getPath());
        }

        public int getDefaultPriority() {
            return 1234;
        }
    }
}

