/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.growthacceleratortiers.core.definitions;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.MainCreativeTab;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import com.google.common.base.Preconditions;
import dev.satherov.growthacceleratortiers.api.ids.GATBlockIds;
import dev.satherov.growthacceleratortiers.block.GATBoostedBlock;
import dev.satherov.growthacceleratortiers.block.GATCrankedBlock;
import dev.satherov.growthacceleratortiers.block.GATDirectionalBlock;
import dev.satherov.growthacceleratortiers.core.annotations.NothingNull;
import dev.satherov.growthacceleratortiers.core.definitions.GATItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

@NothingNull
public class GATBlocks {
    public static final DeferredRegister.Blocks DR = DeferredRegister.createBlocks((String)"growthacceleratortiers");
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    public static final BlockDefinition<GATCrankedBlock> CRANKED_GROWTH_ACCELERATOR = GATBlocks.block("Cranked Growth Accelerator", GATBlockIds.CRANKED_GROWTH_ACCELERATOR, GATCrankedBlock::new);
    public static final BlockDefinition<GATDirectionalBlock> DIRECTIONAL_GROWTH_ACCELERATOR = GATBlocks.block("Directional Growth Accelerator", GATBlockIds.DIRECTIONAL_GROWTH_ACCELERATOR, GATDirectionalBlock::new);
    public static final BlockDefinition<GATBoostedBlock> BOOSTED_GROWTH_ACCELERATOR = GATBlocks.block("Boosted Growth Accelerator", GATBlockIds.BOOSTED_GROWTH_ACCELERATOR, GATBoostedBlock::new);

    private static <T extends Block> BlockDefinition<T> block(String englishName, ResourceLocation id, Supplier<T> blockSupplier) {
        return GATBlocks.block(englishName, id, blockSupplier, null);
    }

    private static <T extends Block> BlockDefinition<T> block(String englishName, ResourceLocation id, Supplier<T> blockSupplier, @Nullable BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        Preconditions.checkArgument((boolean)id.getNamespace().equals("growthacceleratortiers"));
        DeferredBlock deferredBlock = DR.register(id.getPath(), blockSupplier);
        DeferredItem deferredItem = GATItems.DR.register(id.getPath(), () -> {
            Block block = (Block)deferredBlock.get();
            Item.Properties itemProperties = new Item.Properties();
            if (itemFactory != null) {
                BlockItem item = (BlockItem)itemFactory.apply(block, itemProperties);
                if (item == null) {
                    throw new IllegalArgumentException("BlockItem factory for " + String.valueOf(id) + " returned null");
                }
                return item;
            }
            if (block instanceof AEBaseBlock) {
                return new AEBaseBlockItem(block, itemProperties);
            }
            return new BlockItem(block, itemProperties);
        });
        ItemDefinition itemDef = new ItemDefinition(englishName, deferredItem);
        MainCreativeTab.add((ItemDefinition)itemDef);
        BlockDefinition definition = new BlockDefinition(englishName, deferredBlock, itemDef);
        BLOCKS.add(definition);
        return definition;
    }

    public static List<BlockDefinition<?>> getBlocks() {
        return BLOCKS;
    }
}

