/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2importexportcard;

import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.init.client.InitScreens;
import com.ultramega.ae2importexportcard.container.UpgradeContainerMenu;
import com.ultramega.ae2importexportcard.network.LockSlotUpdateData;
import com.ultramega.ae2importexportcard.network.UpgradeUpdateData;
import com.ultramega.ae2importexportcard.registry.ModCreativeTabs;
import com.ultramega.ae2importexportcard.registry.ModDataComponents;
import com.ultramega.ae2importexportcard.registry.ModItems;
import com.ultramega.ae2importexportcard.screen.UpgradeScreen;
import com.ultramega.ae2importexportcard.util.UpgradeType;
import de.mari_023.ae2wtlib.api.AE2wtlibAPI;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="ae2importexportcard")
public class AE2ImportExportCard {
    public static final String MODID = "ae2importexportcard";
    public static final String IMPORT_CARD_ID = "import_card";
    public static final String EXPORT_CARD_ID = "export_card";
    public static boolean AE2WTLIB_INSTALLED = false;

    public AE2ImportExportCard(IEventBus modEventBus) {
        AE2ImportExportCard.registerMenus();
        ModDataComponents.DATA_COMPONENTS.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        modEventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar(MODID);
            registrar.playBidirectional(LockSlotUpdateData.TYPE, LockSlotUpdateData.STREAM_CODEC, LockSlotUpdateData::handle);
            registrar.playBidirectional(UpgradeUpdateData.TYPE, UpgradeUpdateData.STREAM_CODEC, UpgradeUpdateData::handle);
        });
        modEventBus.addListener(this::registerScreens);
        modEventBus.addListener(this::commonSetup);
    }

    static void registerMenus() {
        MenuType<UpgradeContainerMenu> a = UpgradeContainerMenu.TYPE_IMPORT;
        MenuType<UpgradeContainerMenu> b = UpgradeContainerMenu.TYPE_EXPORT;
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        InitScreens.register((RegisterMenuScreensEvent)event, UpgradeContainerMenu.TYPE_IMPORT, (menu, inventory, component, style) -> new UpgradeScreen(UpgradeType.IMPORT, (UpgradeContainerMenu)menu, inventory, component, style), (String)"/screens/import_card.json");
        InitScreens.register((RegisterMenuScreensEvent)event, UpgradeContainerMenu.TYPE_EXPORT, (menu, inventory, component, style) -> new UpgradeScreen(UpgradeType.EXPORT, (UpgradeContainerMenu)menu, inventory, component, style), (String)"/screens/export_card.json");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Upgrades.add((ItemLike)((ItemLike)ModItems.IMPORT_CARD.get()), (ItemLike)AEItems.WIRELESS_TERMINAL, (int)1);
        Upgrades.add((ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (ItemLike)AEItems.WIRELESS_TERMINAL, (int)1);
        Upgrades.add((ItemLike)((ItemLike)ModItems.IMPORT_CARD.get()), (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)1);
        Upgrades.add((ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)1);
        if (ModList.get().isLoaded("ae2wtlib")) {
            AE2WTLIB_INSTALLED = true;
            Upgrades.add((ItemLike)((ItemLike)ModItems.IMPORT_CARD.get()), (ItemLike)AE2wtlibAPI.getWUT(), (int)1);
            Upgrades.add((ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (ItemLike)AE2wtlibAPI.getWUT(), (int)1);
        }
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)((ItemLike)ModItems.IMPORT_CARD.get()), (int)1);
        Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (int)1);
        Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)((ItemLike)ModItems.IMPORT_CARD.get()), (int)1);
        Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, (ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (int)1);
        Upgrades.add((ItemLike)AEItems.SPEED_CARD, (ItemLike)((ItemLike)ModItems.EXPORT_CARD.get()), (int)1);
    }

    public static boolean isImportOrExportCard(UpgradeType type, ItemStack upgrade) {
        return type == UpgradeType.IMPORT && upgrade.getItem() == ModItems.IMPORT_CARD.get() || type == UpgradeType.EXPORT && upgrade.getItem() == ModItems.EXPORT_CARD.get();
    }
}

