/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2importexportcard.util;

import appeng.api.config.Setting;
import appeng.api.ids.AEComponents;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.util.ConfigManager;
import com.ultramega.ae2importexportcard.AE2ImportExportCard;
import com.ultramega.ae2importexportcard.util.UpgradeType;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public interface CardConfigManager {
    public static IConfigManagerBuilder builder(UpgradeType type, ItemStack gridStack, ItemStack stack) {
        return CardConfigManager.builder(type, gridStack, () -> stack);
    }

    public static IConfigManagerBuilder builder(UpgradeType type, ItemStack gridStack, final Supplier<ItemStack> stack) {
        final ConfigManager manager = new ConfigManager((mgr, settingName) -> {
            ItemContainerContents upgrades = (ItemContainerContents)gridStack.getOrDefault(AEComponents.UPGRADES, (Object)ItemContainerContents.EMPTY);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < upgrades.getSlots(); ++i) {
                ItemStack stackInSlot = upgrades.getStackInSlot(i);
                if (AE2ImportExportCard.isImportOrExportCard(type, stackInSlot)) {
                    stackInSlot.set(AEComponents.EXPORTED_SETTINGS, (Object)mgr.exportSettings());
                }
                stacks.add(stackInSlot);
            }
            gridStack.set(AEComponents.UPGRADES, (Object)ItemContainerContents.fromItems(stacks));
        });
        return new IConfigManagerBuilder(){

            public <T extends Enum<T>> IConfigManagerBuilder registerSetting(Setting<T> setting, T defaultValue) {
                manager.registerSetting(setting, defaultValue);
                return this;
            }

            public IConfigManager build() {
                manager.importSettings((Map)((ItemStack)stack.get()).getOrDefault(AEComponents.EXPORTED_SETTINGS, Map.of()));
                return manager;
            }
        };
    }
}

