/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.events;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.EnchantmentUtil;
import com.kwpugh.gobber2.util.InfiniteEffectManager;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public final class AbilityEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        ItemStack stack;
        ItemStack invStack;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        Player player = event.getEntity();
        Level level = player.level();
        BlockPos pos = player.getOnPos();
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get())) {
            invStack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionLesserHealingHunger, ConfigJankson.getConfig().medallionLesserHealingSaturation);
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get())) {
            invStack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionLesserHealingHunger, ConfigJankson.getConfig().medallionLesserHealingSaturation);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get())) {
            invStack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionHealingHunger, ConfigJankson.getConfig().medallionHealingSaturation);
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get())) {
            invStack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING2.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionHealingHunger, ConfigJankson.getConfig().medallionHealingSaturation);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get())) {
            invStack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionGreaterHealingHunger, ConfigJankson.getConfig().medallionGreaterHealingSaturation);
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get())) {
            invStack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HEALING3.get());
            PlayerSpecialAbilities.giveRegenEffect(level, player, invStack, ConfigJankson.getConfig().medallionGreaterHealingHunger, ConfigJankson.getConfig().medallionGreaterHealingSaturation);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_SEA.get())) {
            invStack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_SEA.get());
            if (EnableUtil.isEnabled(invStack) && player.isInWater()) {
                player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, ConfigJankson.getConfig().effectDuration, 2, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, ConfigJankson.getConfig().effectDuration, 2, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_SEA.get()) && EnableUtil.isEnabled(invStack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_SEA.get())) && player.isInWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, ConfigJankson.getConfig().effectDuration, 2, false, false));
            player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, ConfigJankson.getConfig().effectDuration, 2, false, false));
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get());
            if (EnableUtil.isEnabled(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, ConfigJankson.getConfig().effectDuration, 2, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_HERO.get()))) {
            player.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, ConfigJankson.getConfig().effectDuration, 2, false, false));
        }
        if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_SHIELDING.get())) {
            PlayerSpecialAbilities.giveProjectileShield(level, player, ConfigJankson.getConfig().medallionShieldingVertical, ConfigJankson.getConfig().medallionShieldingHoriz);
        }
        if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_SUFFERING.get())) {
            PlayerSpecialAbilities.inflictSuffering(level, pos, ConfigJankson.getConfig().medallionSufferingRange, ConfigJankson.getConfig().medallionSufferingDamage);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_HASTE.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_HASTE.get());
            if (EnableUtil.isEnabled(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, ConfigJankson.getConfig().effectDuration, 1, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_HASTE.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_HASTE.get()))) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, ConfigJankson.getConfig().effectDuration, 1, false, false));
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_STRENGTH.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_STRENGTH.get());
            if (EnableUtil.isEnabled(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, ConfigJankson.getConfig().effectDuration, ConfigJankson.getConfig().ringStrengthLevel, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, ConfigJankson.getConfig().effectDuration, ConfigJankson.getConfig().ringStrengthResistanceLevel, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_STRENGTH.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_STRENGTH.get()))) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, ConfigJankson.getConfig().effectDuration, ConfigJankson.getConfig().ringStrengthLevel, false, false));
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, ConfigJankson.getConfig().effectDuration, ConfigJankson.getConfig().ringStrengthResistanceLevel, false, false));
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_LUCK.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_LUCK.get());
            if (EnableUtil.isEnabled(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.LUCK, ConfigJankson.getConfig().effectDuration, 1, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_LUCK.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_LUCK.get()))) {
            player.addEffect(new MobEffectInstance(MobEffects.LUCK, ConfigJankson.getConfig().effectDuration, 1, false, false));
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_CURING.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_CURING.get())) {
            PlayerSpecialAbilities.doCuring(player);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get());
            if (EnableUtil.isEnabled(stack)) {
                PlayerSpecialAbilities.doAttraction(level, player, stack);
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ATTRACTION.get()))) {
            PlayerSpecialAbilities.doAttraction(level, player, stack);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get())) {
            stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get());
            if (EnableUtil.isEnabled(stack)) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ConfigJankson.getConfig().effectDuration, 1, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, ConfigJankson.getConfig().effectDuration, 1, false, false));
            }
        } else if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get()) && EnableUtil.isEnabled(stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_SWIFTNESS.get()))) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, ConfigJankson.getConfig().effectDuration, 1, false, false));
            player.addEffect(new MobEffectInstance(MobEffects.JUMP, ConfigJankson.getConfig().effectDuration, 1, false, false));
        }
        InfiniteEffectManager.update(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.level().isClientSide) {
                return;
            }
            if (event.getSource().is(DamageTypeTags.IS_EXPLOSION) && PlayerEquipUtil.hasBlastProtection(player)) {
                event.setCanceled(true);
            }
            if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && PlayerEquipUtil.hasVoidProtection(player)) {
                event.setCanceled(true);
            }
            if (event.getSource().is(DamageTypeTags.IS_FALL) && PlayerEquipUtil.hasFallProtection(player)) {
                event.setCanceled(true);
            }
            if (event.getSource().is(DamageTypeTags.IS_FIRE) && PlayerEquipUtil.hasFireProtection(player)) {
                event.setCanceled(true);
            }
            if (event.getSource().is(DamageTypeTags.IS_DROWNING) && PlayerEquipUtil.hasWaterBreathing(player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void LivingChangeTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getOriginalAboutToBeSetTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.level().isClientSide) {
                return;
            }
            LivingEntity attacker = event.getEntity();
            if (PlayerEquipUtil.hasStealth(player) && attacker instanceof Phantom) {
                event.setCanceled(true);
            }
            if (PlayerEquipUtil.hasStealthRingInHand(player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null && event.getEntity() instanceof Mob) {
            Player player = event.getAttackingPlayer();
            if (player.level().isClientSide) {
                return;
            }
            if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get())) {
                int orgExp = event.getOriginalExperience();
                int newExp = orgExp * ConfigJankson.getConfig().medallionExpOrbsMultiplier;
                event.setDroppedExperience(newExp);
            }
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockDropsEvent event) {
        Entity entity;
        Block block = event.getState().getBlock();
        if (block instanceof DropExperienceBlock && event.getBreaker() != null && (entity = event.getBreaker()) instanceof Player) {
            Player player = (Player)entity;
            if (player.level().isClientSide) {
                return;
            }
            if ((PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_EXP.get())) && !EnchantmentUtil.hasEnchantment((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, player.getMainHandItem())) {
                event.setDroppedExperience(ConfigJankson.getConfig().medallionExpOrbsMultiplier);
            }
        }
    }

    @SubscribeEvent
    public static void onDropAirWalkingRing(ItemTossEvent event) {
        Player player = event.getPlayer();
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        if (player.level().isClientSide) {
            return;
        }
        if (stack.getItem().equals(ItemInit.GOBBER2_RING_AIRWALKING.get())) {
            player.setNoGravity(false);
        }
        if (stack.getItem().equals(ItemInit.GOBBER2_RING_ASCENT.get()) && player.hasEffect(MobEffects.LEVITATION)) {
            player.removeEffect(MobEffects.LEVITATION);
        }
    }
}

