/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorDragon
extends ArmorItem {
    public ArmorDragon(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties properties) {
        super(holder, type, properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.level().isClientSide) {
                return;
            }
            ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
            ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
            ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
            ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
            if (!player.getPersistentData().contains("wearingFullDragonArmor")) {
                player.getPersistentData().putBoolean("wearingFullDragonArmor", false);
            }
            boolean iswearingFullDragonArmor = head != null && head.getItem() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest != null && chest.getItem() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs != null && legs.getItem() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet != null && feet.getItem() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
            boolean wasWearingDragonArmorLastTick = player.getPersistentData().getBoolean("wearingFullDragonArmor");
            if (!iswearingFullDragonArmor && wasWearingDragonArmorLastTick && !player.isCreative()) {
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
                player.onUpdateAbilities();
            } else if (iswearingFullDragonArmor && (level.dimension().equals(Level.OVERWORLD) || level.dimension().equals(Level.NETHER) || level.dimension().equals(Level.END))) {
                player.getAbilities().mayfly = true;
                player.onUpdateAbilities();
            } else if (iswearingFullDragonArmor && ConfigJankson.getConfig().enableDragonArmorFlyAnywhere) {
                player.getAbilities().mayfly = true;
                player.onUpdateAbilities();
            }
            player.getPersistentData().putBoolean("wearingFullDragonArmor", iswearingFullDragonArmor);
            if (PlayerEquipUtil.isWearingFullDragonArmor(player)) {
                if (ConfigJankson.getConfig().enableDragonArmorAutofeed) {
                    PlayerSpecialAbilities.giveRegenEffect(level, player, stack, ConfigJankson.getConfig().dragonArmorHunger, ConfigJankson.getConfig().dragonArmorSaturation);
                }
                if (ConfigJankson.getConfig().enableDragonArmorNegEffectProtection) {
                    PlayerSpecialAbilities.doCuring(player);
                }
            }
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().dragonArmorUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == ItemInit.GOBBER2_INGOT_END.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (ConfigJankson.getConfig().enableDragonArmorFireProtection || ConfigJankson.getConfig().enableDragonArmorWaterBreathing || ConfigJankson.getConfig().enableDragonArmorAutofeed || ConfigJankson.getConfig().enableDragonArmorNoFallDamage || ConfigJankson.getConfig().enableDragonArmorNegEffectProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip1").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableDragonArmorFireProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip2").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableDragonArmorWaterBreathing) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip3").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableDragonArmorAutofeed) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip4").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip5").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableDragonArmorNoFallDamage) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip6").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableDragonArmorNegEffectProtection) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip7").withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor_dragon.tip8").withStyle(ChatFormatting.GREEN));
    }
}

