/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorGobber
extends ArmorItem {
    public ArmorGobber(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties settings) {
        super(holder, type, settings);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotID, boolean isSelected) {
        Player player;
        super.inventoryTick(stack, level, entity, slotID, isSelected);
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof Player && PlayerEquipUtil.isWearingFullGobberArmor(player = (Player)entity) && ConfigJankson.getConfig().enableGobberArmorAutofeed) {
            PlayerSpecialAbilities.giveRegenEffect(level, player, stack, ConfigJankson.getConfig().gobberArmorhunger, ConfigJankson.getConfig().gobberArmorSaturation);
        }
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == ItemInit.GOBBER2_INGOT.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (ConfigJankson.getConfig().enableGobberArmorWaterBreathing || ConfigJankson.getConfig().enableGobberArmorAutofeed) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor.tip1").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableGobberArmorWaterBreathing) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor.tip2").withStyle(ChatFormatting.GREEN));
        }
        if (ConfigJankson.getConfig().enableGobberArmorAutofeed) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor.tip3").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_armor.tip4").withStyle(ChatFormatting.GREEN));
        }
    }
}

