/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.medallions;

import com.kwpugh.gobber2.util.ExpUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MedallionExp
extends Item {
    public static final int MAX_STORAGE = 1425;
    private final Random random = new Random();

    public MedallionExp(Item.Properties properties) {
        super(new Item.Properties().durability(1425));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && this.getXPStored(stack) != 1425) {
            int playerXP = ExpUtils.getPlayerXP(player);
            if (playerXP == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, playerXP);
            ExpUtils.addPlayerXP(player, -actuallyStored);
            if (!world.isClientSide) {
                world.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!player.isShiftKeyDown() && this.getXPStored(stack) != 0) {
            if (this.getXPStored(stack) > 1401) {
                ExpUtils.addPlayerXP(player, 1401);
                this.setStoredXP(stack, this.getXPStored(stack) - 1401);
            } else {
                ExpUtils.addPlayerXP(player, this.getXPStored(stack));
                this.setStoredXP(stack, 0);
            }
            if (!world.isClientSide) {
                float pitchMultiplier = player.experienceLevel > 30 ? 1.0f : (float)player.experienceLevel / 30.0f;
                world.playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void onCraftedBy(ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        stack.setDamageValue(1425);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return this.getXPStored(stack) > 0;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public int addXP(ItemStack stack, int amount) {
        int stored = this.getXPStored(stack);
        if (stored + amount > 1425) {
            this.setStoredXP(stack, 1425);
            return 1425 - stored;
        }
        this.setStoredXP(stack, stored + amount);
        return amount;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.setDamageValue(1425 - amount);
    }

    public int getXPStored(ItemStack stack) {
        return 1425 - stack.getDamageValue();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_medallion_exp.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_medallion_exp.line2", (Object[])new Object[]{this.getXPStored(stack)}).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_medallion_exp.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_inventory").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_enderchest").withStyle(ChatFormatting.BLUE));
    }
}

