/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.medallions;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MedallionSuffering
extends Item {
    public MedallionSuffering(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = player.getOnPos();
            ItemStack equippedOff = player.getOffhandItem();
            if (stack == equippedOff) {
                PlayerSpecialAbilities.inflictSuffering(level, pos, ConfigJankson.getConfig().medallionSufferingRange, ConfigJankson.getConfig().medallionSufferingDamage);
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_medallion_suffering.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_off_hand").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_enderchest").withStyle(ChatFormatting.BLUE));
    }
}

