/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RingDismissal
extends Item {
    public RingDismissal(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player && !world.isClientSide) {
            Player player = (Player)entity;
            ItemStack equipped = player.getMainHandItem();
            if (!world.isClientSide && stack == equipped) {
                double d1;
                double d0;
                double z;
                double y;
                Vec3 look = player.getLookAngle().normalize();
                double lookX = look.x();
                double lookY = look.y();
                double lookZ = look.z();
                double x = player.getX();
                Mob hostileMob = this.scanForHostileMobs(world, x, y = player.getY(), z = player.getZ(), d0 = (double)ConfigJankson.getConfig().ringDismissalRange, d1 = 4.0);
                if (hostileMob != null) {
                    hostileMob.push(lookX * (double)ConfigJankson.getConfig().ringDismissalVelocity, lookY * (double)ConfigJankson.getConfig().ringDismissalLift, lookZ * (double)ConfigJankson.getConfig().ringDismissalVelocity);
                }
            }
        }
    }

    private Mob scanForHostileMobs(Level world, double xpos, double ypos, double zpos, double d0, double d1) {
        List list = world.getEntitiesOfClass(Mob.class, new AABB(xpos - d0, ypos - d1, zpos - d0, xpos + d0, ypos + d1, zpos + d0));
        Mob closestMob = null;
        for (Mob entitymob : list) {
            MobCategory isCreature = entitymob.getClassification(true);
            if (isCreature == MobCategory.CREATURE || entitymob instanceof Evoker || entitymob instanceof Guardian || entitymob instanceof Vex || entitymob instanceof Vindicator || entitymob instanceof WitherBoss || entitymob instanceof EnderDragon) continue;
            closestMob = entitymob;
            return closestMob;
        }
        return null;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_dismissal.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.works_in_main_hand").withStyle(ChatFormatting.YELLOW));
    }
}

