/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.GrowingUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RingFarmer
extends Item {
    public RingFarmer(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return super.use(world, player, hand);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int par4, boolean par5) {
        Player player;
        block5: {
            block4: {
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!world.isClientSide) break block5;
            }
            return;
        }
        ItemStack equippedMain = player.getMainHandItem();
        if (stack == equippedMain && !world.isClientSide) {
            GrowingUtil.growCrops(world, player, ConfigJankson.getConfig().ringFarmerTickDelay, ConfigJankson.getConfig().ringFarmerRadius);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_farmer.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_farmer.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_farmer.line3", (Object[])new Object[]{ConfigJankson.getConfig().ringFarmerRadius}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

