/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.events.MinerBlock;
import com.kwpugh.gobber2.events.MinerBlockManager;
import com.kwpugh.gobber2.util.MinerBlockTest;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RingMiner
extends Item {
    public RingMiner(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack equippedMain = player.getMainHandItem();
        if (equippedMain == stack) {
            player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().ringMinerCooldown);
            if (!level.isClientSide) {
                for (int x = ConfigJankson.getConfig().ringMinerHorizRange; x >= -ConfigJankson.getConfig().ringMinerHorizRange; --x) {
                    for (int y = ConfigJankson.getConfig().ringMinerVerticalRange; y >= 0; --y) {
                        for (int z = ConfigJankson.getConfig().ringMinerHorizRange; z >= -ConfigJankson.getConfig().ringMinerHorizRange; --z) {
                            Block block;
                            BlockPos pos = player.blockPosition().offset(x, y, z);
                            BlockState state = level.getBlockState(pos);
                            if (!MinerBlockTest.canBreak(state, block = state.getBlock())) continue;
                            if (player.isCrouching()) {
                                MinerBlockManager.addToList(new MinerBlock(level, player, pos, !ConfigJankson.getConfig().ringMinerReverseDropMode));
                                continue;
                            }
                            MinerBlockManager.addToList(new MinerBlock(level, player, pos, ConfigJankson.getConfig().ringMinerReverseDropMode));
                        }
                    }
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line1").withStyle(ChatFormatting.GREEN));
        if (ConfigJankson.getConfig().ringMinerReverseDropMode) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line5").withStyle(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line6").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line2").withStyle(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line3").withStyle(ChatFormatting.YELLOW));
        }
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.line4", (Object[])new Object[]{ConfigJankson.getConfig().ringMinerHorizRange * 2 + 1, ConfigJankson.getConfig().ringMinerVerticalRange}).withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_miner.cooldown", (Object[])new Object[]{ConfigJankson.getConfig().ringMinerCooldown}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

