/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.components.LocationComponent;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RingTeleport
extends Item {
    public RingTeleport(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Optional<BlockPos> blockPos = RingTeleport.getBlockPos(stack);
        String dimension = RingTeleport.getDimension(stack);
        if (blockPos.isPresent() && !player.isCrouching()) {
            BlockPos pos = blockPos.get();
            this.teleport(player, level, stack, pos, dimension);
        }
        if (player.isCrouching()) {
            RingTeleport.clearPosition(stack, level);
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_teleport.line3").withStyle(ChatFormatting.BOLD), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction direction = context.getClickedFace();
        ItemStack stack = context.getPlayer().getMainHandItem();
        Optional<BlockPos> blockPos = RingTeleport.getBlockPos(stack);
        if (blockPos.isEmpty() && !player.isCrouching()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_teleport.line19"), true);
        }
        if (blockPos.isEmpty() && player.isCrouching()) {
            RingTeleport.setPosition(stack, world, pos.relative(direction), player);
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_teleport.line1"), true);
        }
        if (blockPos.isPresent()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.gobber2.ring_teleport.line2", (Object[])new Object[]{this.getLocationString(stack)}).withStyle(ChatFormatting.YELLOW), true);
        }
        return InteractionResult.SUCCESS;
    }

    public static void clearPosition(ItemStack stack, Level level) {
        if (level.isClientSide) {
            return;
        }
        stack.set(Gobber2.GOBBER_LOCATION_TYPE, null);
    }

    public static void setPosition(ItemStack stack, Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return;
        }
        ResourceKey resourceKey = level.dimension();
        ResourceLocation value = resourceKey.location();
        LocationComponent component = new LocationComponent.Builder().dimension(value).blocPos(pos).build();
        stack.set(Gobber2.GOBBER_LOCATION_TYPE, (Object)component);
    }

    public static Optional<BlockPos> getBlockPos(ItemStack stack) {
        Optional<BlockPos> blockPos = Optional.empty();
        LocationComponent component = (LocationComponent)stack.get(Gobber2.GOBBER_LOCATION_TYPE);
        if (component != null) {
            blockPos = Optional.ofNullable(component.blockPos());
        }
        return blockPos;
    }

    public static String getDimension(ItemStack stack) {
        String dimension = null;
        LocationComponent component = (LocationComponent)stack.get(Gobber2.GOBBER_LOCATION_TYPE);
        if (component != null) {
            dimension = String.valueOf(component.dimension());
        }
        return dimension;
    }

    public void teleport(Player player, Level level, ItemStack stack, BlockPos pos, String dimension) {
        if (level.isClientSide) {
            return;
        }
        BlockPos pos1 = pos;
        String dim = dimension;
        ResourceKey currentDim = level.dimension();
        ServerLevel serverWorld = ((ServerLevel)level).getServer().getLevel(currentDim);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceKey storedKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dim));
        ServerLevel storedWorld = ((ServerLevel)level).getServer().getLevel(storedKey);
        if (serverWorld == storedWorld) {
            serverPlayer.teleportTo((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
        } else {
            serverPlayer.teleportTo(storedWorld, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), serverPlayer.getRespawnAngle(), serverPlayer.getRespawnAngle());
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public String getLocationString(ItemStack stack) {
        String displayInfo = null;
        Optional<BlockPos> pos = RingTeleport.getBlockPos(stack);
        String dim = RingTeleport.getDimension(stack);
        boolean hasValue = pos.isPresent();
        if (hasValue) {
            int storedX = pos.get().getX();
            int storedY = pos.get().getY();
            int storedZ = pos.get().getZ();
            displayInfo = dim + "  x: " + storedX + " y: " + storedY + " z: " + storedZ;
        }
        return displayInfo;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_teleport.line9").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_teleport.line11").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_teleport.line12").withStyle(ChatFormatting.RED));
        String displayInfo = this.getLocationString(stack);
        if (displayInfo != null) {
            tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_teleport.line13").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.translatable((String)"item.gobber2.ring_teleport.line14", (Object[])new Object[]{displayInfo}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

