/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RingVoid
extends Item {
    DimensionTransition dimensionTransition;

    public RingVoid(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    this.dimensionTransition = this.getPortalDestination(serverLevel, serverPlayer);
                    serverPlayer.stopRiding();
                    serverPlayer.changeDimension(this.dimensionTransition);
                }
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public DimensionTransition getPortalDestination(ServerLevel level, ServerPlayer player) {
        ResourceKey resourcekey = level.dimension() == Level.END ? Level.OVERWORLD : Level.END;
        ServerLevel serverlevel = level.getServer().getLevel(resourcekey);
        if (serverlevel == null) {
            return null;
        }
        boolean flag = resourcekey == Level.END;
        BlockPos blockpos = flag ? ServerLevel.END_SPAWN_POINT : serverlevel.getSharedSpawnPos();
        Vec3 vec3 = blockpos.getBottomCenter();
        float f = player.getYRot();
        if (flag) {
            EndPlatformFeature.createEndPlatform((ServerLevelAccessor)serverlevel, (BlockPos)BlockPos.containing((Position)vec3).below(), (boolean)true);
            f = Direction.WEST.toYRot();
            if (player instanceof ServerPlayer) {
                vec3 = vec3.subtract(0.0, 1.0, 0.0);
            }
        } else {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = player;
                return serverplayer.findRespawnPositionAndUseSpawnBlock(false, DimensionTransition.DO_NOTHING);
            }
            vec3 = player.adjustSpawnLocation(serverlevel, blockpos).getBottomCenter();
        }
        return new DimensionTransition(serverlevel, vec3, player.getDeltaMovement(), f, player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_void.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_void.line2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_void.line3").withStyle(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_ring_void.line4").withStyle(ChatFormatting.RED));
    }
}

