/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MushroomBlock;
import org.jetbrains.annotations.NotNull;

public class StaffClearing
extends Item {
    public StaffClearing(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            BlockPos playerPos = new BlockPos((Vec3i)player.getOnPos());
            for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-11, -2, -11), (BlockPos)playerPos.offset(11, 2, 11))) {
                Block block = world.getBlockState(targetPos).getBlock();
                if (block == Blocks.SHORT_GRASS || block == Blocks.DEAD_BUSH || block == Blocks.TALL_GRASS || block == Blocks.FERN || block == Blocks.LARGE_FERN || block instanceof MushroomBlock || block instanceof FlowerBlock) {
                    world.destroyBlock(targetPos, true);
                }
                if (!(block instanceof LeavesBlock) || !player.isShiftKeyDown()) continue;
                world.destroyBlock(targetPos, true);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_clearing.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_clearing.line2").withStyle(ChatFormatting.GREEN));
    }
}

