/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.GrowingUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffFarmer
extends Item {
    public StaffFarmer(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int par4, boolean par5) {
        if (!(entity instanceof Player) || world.isClientSide) {
            return;
        }
        Player player = (Player)entity;
        ItemStack equippedMain = player.getMainHandItem();
        if (stack == equippedMain && !world.isClientSide) {
            GrowingUtil.growCrops(world, player, ConfigJankson.getConfig().staffFarmerTickDelay, ConfigJankson.getConfig().staffFarmerRadius);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        GrowingUtil.harvestCrops(world, player, ConfigJankson.getConfig().staffFarmerRadius);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_farmer.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_farmer.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_farmer.line4").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_farmer.line2", (Object[])new Object[]{ConfigJankson.getConfig().staffFarmerRadius}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

