/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.blocks.BlockClearGlass;
import com.kwpugh.gobber2.init.BlockInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StaffNature
extends Item {
    Block block;

    public StaffNature(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack stack = context.getItemInHand();
        if (!player.isShiftKeyDown()) {
            if (block == Blocks.ACACIA_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.BIRCH_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.BIRCH_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.DARK_OAK_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.DARK_OAK_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.JUNGLE_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.JUNGLE_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.OAK_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.OAK_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.SPRUCE_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.SPRUCE_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.ACACIA_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.SUGAR_CANE) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.BAMBOO_SAPLING.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
            if (block == Blocks.BAMBOO_SAPLING) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                world.setBlock(pos, Blocks.SUGAR_CANE.defaultBlockState(), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                return InteractionResult.SUCCESS;
            }
        }
        if (player.isShiftKeyDown() && block == Blocks.GLASS) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            world.setBlock(pos, ((BlockClearGlass)((Object)BlockInit.CLEAR_GLASS.get())).defaultBlockState(), 3);
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_nature.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_nature.line2").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_nature.line3").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_nature.line4").withStyle(ChatFormatting.YELLOW));
    }
}

