/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffSniper
extends Item {
    public StaffSniper(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().sniperStaffCooldown);
        if (!level.isClientSide) {
            ArrowItem itemarrow = (ArrowItem)Items.ARROW;
            AbstractArrow entityarrow = itemarrow.createArrow(level, new ItemStack((ItemLike)Items.ARROW), (LivingEntity)player, stack);
            float arrowVelocity = ConfigJankson.getConfig().sniperSpeed;
            entityarrow.shootFromRotation((Entity)player, player.xRotO, player.yRotO, 0.0f, arrowVelocity, ConfigJankson.getConfig().sniperDivergence);
            entityarrow.setBaseDamage((double)ConfigJankson.getConfig().sniperBaseDamage);
            entityarrow.setCritArrow(ConfigJankson.getConfig().sniperAlwaysCriticalHit);
            level.addFreshEntity((Entity)entityarrow);
            entityarrow.pickup = AbstractArrow.Pickup.DISALLOWED;
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sniper.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sniper.line2").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sniper.line3").withStyle(ChatFormatting.YELLOW));
    }
}

