/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.config.ConfigJankson;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StaffSound
extends Item {
    public StaffSound(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        player.startUsingItem(hand);
        return super.use(level, player, hand);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack itemStack, int remainingUseTicks) {
        super.onUseTick(level, livingEntity, itemStack, remainingUseTicks);
        if (this.getUseDuration(itemStack, livingEntity) - remainingUseTicks == 1) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.WARDEN_SONIC_CHARGE, SoundSource.BLOCKS, 5.0f, 1.0f);
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level level, @NotNull LivingEntity livingEntity) {
        if (!level.isClientSide && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown((Item)this, ConfigJankson.getConfig().staffSoundCooldown);
            this.acquireTargets(level, livingEntity, player);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return ConfigJankson.getConfig().staffSoundChargeTime;
    }

    private void acquireTargets(Level level, LivingEntity livingEntity, Player player) {
        if (level.isClientSide) {
            return;
        }
        level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.BLOCKS, 3.0f, 1.0f);
        float heightOffset = 1.55f;
        int distance = 20;
        Vec3 target = livingEntity.position().add(livingEntity.getLookAngle().multiply((double)distance, (double)distance, (double)distance));
        Vec3 shooter = livingEntity.position().add(0.0, (double)heightOffset, 0.0);
        Vec3 offset = target.subtract(shooter);
        Vec3 normalizedOffset = offset.normalize();
        HashSet<Entity> entitiesToHurt = new HashSet<Entity>();
        int i = Mth.floor((double)shooter.length()) + 7;
        for (int j = 1; j < i; ++j) {
            Vec3 pos = shooter.add(normalizedOffset.scale((double)j));
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
            AABB killBox = new AABB(new BlockPos((int)pos.x(), (int)pos.y(), (int)pos.z())).inflate((double)ConfigJankson.getConfig().staffSoundKillBoxExpand);
            entitiesToHurt.addAll(level.getEntitiesOfClass(LivingEntity.class, killBox, victims -> {
                TamableAnimal tameable;
                return !(victims instanceof TamableAnimal && (tameable = (TamableAnimal)victims).isOwnedBy(livingEntity));
            }));
        }
        this.applyDamage(level, livingEntity, player, normalizedOffset, entitiesToHurt);
    }

    private void applyDamage(Level level, LivingEntity livingEntity, Player player, Vec3 normalized, Set<Entity> entitiesToHurt) {
        for (Entity targetEntity : entitiesToHurt) {
            LivingEntity victim;
            if (!(targetEntity instanceof LivingEntity) || (victim = (LivingEntity)targetEntity) == player) continue;
            victim.hurt(level.damageSources().sonicBoom((Entity)livingEntity), ConfigJankson.getConfig().staffSoundDamage);
            double vertical = 0.75 * (1.0 - victim.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            double horizontal = 3.75 * (1.0 - victim.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            victim.push(normalized.x() * horizontal, normalized.y() * vertical, normalized.z() * horizontal);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sound.tip1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sound.tip2").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_sound.tip3", (Object[])new Object[]{(int)ConfigJankson.getConfig().staffSoundDamage}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }
}

