/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.util.BlockHitResultUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class StaffStars
extends Item {
    public StaffStars(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        int side;
        BlockHitResult pos;
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && (pos = BlockHitResultUtil.getNearestPositionWithAir(level, player, 100)) != null && (pos.getType() == HitResult.Type.BLOCK || player.xRotO >= -5.0f) && (side = pos.getType().ordinal()) != -1) {
            BlockPos placePos = pos.getBlockPos();
            Direction direction = pos.getDirection();
            BlockPos setPos = placePos;
            boolean setWallTorch = false;
            for (int i = 0; i < 20; ++i) {
                if (level.getBlockState(placePos).getBlock().equals(Blocks.AIR) || level.getBlockState(placePos).getBlock().equals(Blocks.WATER) || level.getBlockState(placePos).getBlock().equals(Blocks.LAVA)) continue;
                switch (pos.getDirection()) {
                    case NORTH: {
                        setPos = new BlockPos(placePos.getX(), placePos.getY(), placePos.getZ() - 1);
                        setWallTorch = true;
                        break;
                    }
                    case SOUTH: {
                        setPos = new BlockPos(placePos.getX(), placePos.getY(), placePos.getZ() + 1);
                        setWallTorch = true;
                        break;
                    }
                    case WEST: {
                        setPos = new BlockPos(placePos.getX() - 1, placePos.getY(), placePos.getZ());
                        setWallTorch = true;
                        break;
                    }
                    case EAST: {
                        setPos = new BlockPos(placePos.getX() + 1, placePos.getY(), placePos.getZ());
                        setWallTorch = true;
                        break;
                    }
                    case DOWN: {
                        break;
                    }
                }
                if (setWallTorch) {
                    level.setBlockAndUpdate(setPos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pos.getDirection()));
                    continue;
                }
                level.setBlockAndUpdate(placePos.above(), Blocks.TORCH.defaultBlockState());
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext iuc) {
        BlockPos torchPos;
        BlockPos pos = iuc.getClickedPos();
        Level world = iuc.getLevel();
        BlockState state = iuc.getLevel().getBlockState(pos);
        Block block = iuc.getLevel().getBlockState(pos).getBlock();
        if (iuc.getLevel().getBlockState(pos).getBlock() == Blocks.TORCH || iuc.getLevel().getBlockState(pos).getBlock() == Blocks.WALL_TORCH) {
            return InteractionResult.FAIL;
        }
        boolean isWallTorch = false;
        switch (iuc.getClickedFace()) {
            case UP: {
                torchPos = new BlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
                break;
            }
            case NORTH: {
                torchPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1);
                isWallTorch = true;
                break;
            }
            case SOUTH: {
                torchPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1);
                isWallTorch = true;
                break;
            }
            case WEST: {
                torchPos = new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ());
                isWallTorch = true;
                break;
            }
            case EAST: {
                torchPos = new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ());
                isWallTorch = true;
                break;
            }
            default: {
                return InteractionResult.FAIL;
            }
        }
        if (iuc.getLevel().getBlockState(torchPos).isAir() || iuc.getLevel().getBlockState(torchPos).getFluidState().isSource()) {
            if (state.isRedstoneConductor((BlockGetter)world, pos) || state.getBlock() instanceof FenceBlock) {
                if (isWallTorch) {
                    iuc.getLevel().setBlockAndUpdate(torchPos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)iuc.getClickedFace()));
                    iuc.getLevel().playSound(null, iuc.getPlayer().blockPosition(), SoundEvents.WOOD_PLACE, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                } else {
                    iuc.getLevel().setBlockAndUpdate(torchPos, Blocks.TORCH.defaultBlockState());
                    iuc.getLevel().playSound(null, iuc.getPlayer().blockPosition(), SoundEvents.WOOD_PLACE, SoundSource.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_stars.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_stars.line2").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_stars.line3").withStyle(ChatFormatting.YELLOW));
    }
}

