/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.staffs;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.EnchantmentUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffTransformation
extends Item {
    static List<EnchantmentInstance> instanceList = new ArrayList<EnchantmentInstance>();

    public StaffTransformation(Item.Properties properties) {
        super(properties);
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stackIn) {
        ItemStack stack = stackIn.copy();
        stack.setDamageValue(this.getDamage(stack) + 1);
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            stack.shrink(1);
        }
        return stack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack mainHandStack = player.getMainHandItem();
        ItemStack offHandStack = player.getOffhandItem();
        boolean bl = offHandStack.is(Items.BOOK);
        if (!level.isClientSide && bl && mainHandStack.getDamageValue() < mainHandStack.getMaxDamage() - 1) {
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.FORTUNE), 3));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.LOOTING), 3));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.INFINITY), 1));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE), 3));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), 1));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.SHARPNESS), 5));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.UNBREAKING), 3));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.PIERCING), 4));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK), 2));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY), 5));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.WIND_BURST), 3));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.DENSITY), 5));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.BREACH), 4));
            StaffTransformation.addEntry(new EnchantmentInstance(EnchantmentUtil.getEnchantment(level, (ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK), 3));
            int randomIndex = level.random.nextInt(instanceList.size());
            EnchantmentInstance entry = instanceList.get(randomIndex);
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            book.enchant(entry.enchantment, entry.level);
            offHandStack.shrink(1);
            level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), book));
            if (mainHandStack.getDamageValue() + ConfigJankson.getConfig().staffTransformationDurability / 2 >= mainHandStack.getMaxDamage()) {
                mainHandStack.shrink(mainHandStack.getMaxDamage() - 1);
            } else {
                mainHandStack.setDamageValue(mainHandStack.getDamageValue() + ConfigJankson.getConfig().staffTransformationDurability / 2);
            }
            DamageSource source = player.damageSources().cactus();
            player.hurt(source, 4.0f);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void addEntry(EnchantmentInstance enchantment) {
        instanceList.add(enchantment);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_transformation.line1").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_staff_transformation.line2").withStyle(ChatFormatting.YELLOW));
    }
}

