/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.areatools;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.items.tools.areatools.ExcavatorUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ExcavatorEnd
extends ShovelItem {
    public ExcavatorEnd(Tier tier, Item.Properties builder) {
        super(tier, builder);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Block block = state.getBlock();
            boolean isWithinHarvestLevel = player.getMainHandItem().isCorrectToolForDrops(state);
            boolean isHarvestable = block.canHarvestBlock(state, (BlockGetter)world, pos, player);
            if (isHarvestable && isWithinHarvestLevel && !player.isShiftKeyDown()) {
                ExcavatorUtil.attemptBreakNeighbors(world, pos, player, stack);
            }
        }
        return super.mineBlock(stack, world, state, pos, entity);
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endToolsUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_excavator.line1").withStyle(ChatFormatting.GREEN));
    }
}

