/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.areatools;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.items.tools.areatools.HammerUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HammerEnd
extends PickaxeItem {
    public HammerEnd(Tier tier, Item.Properties builder) {
        super(tier, builder);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Block block = state.getBlock();
            boolean isWithinHarvestLevel = player.getMainHandItem().isCorrectToolForDrops(state);
            boolean isHarvestable = block.canHarvestBlock(state, (BlockGetter)world, pos, player);
            if (isHarvestable && isWithinHarvestLevel && !player.isShiftKeyDown()) {
                HammerUtil.attemptBreakNeighbors(world, pos, player, stack);
            }
        }
        return super.mineBlock(stack, world, state, pos, entity);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!world.isClientSide && player.isShiftKeyDown()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        return super.use(world, player, hand);
    }

    public void onCraftedBy(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Player playerIn) {
        if (ConfigJankson.getConfig().endToolsUnbreakable) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_hammer.line1").withStyle(ChatFormatting.GREEN));
    }
}

